/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.client;

import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import one.xingyi.core.client.IResourceList;
import one.xingyi.core.marshelling.JsonParserAndWriter;
import one.xingyi.core.utils.Function3;

public class JsonResourceList<J, T>
implements IResourceList<T> {
    private JsonParserAndWriter<J> json;
    public final J mirror;
    private final List<J> asList;
    private Function<J, T> maker;
    private Function3<J, Integer, T, J> setter;
    private BiFunction<J, T, J> addFn;

    public JsonResourceList(JsonParserAndWriter<J> json, J mirror, Function<J, T> maker, Function3<J, Integer, T, J> setter, BiFunction<J, T, J> addFn) {
        this.json = json;
        this.mirror = mirror;
        this.asList = json.asList(mirror);
        this.maker = maker;
        this.setter = setter;
        this.addFn = addFn;
    }

    @Override
    public int size() {
        return this.asList.size();
    }

    @Override
    public T get(int n) {
        return this.maker.apply(this.asList.get(n));
    }

    @Override
    public IResourceList<T> withItem(int n, T t) {
        return new JsonResourceList<J, T>(this.json, this.setter.apply(this.mirror, n, t), this.maker, this.setter, this.addFn);
    }

    @Override
    public IResourceList<T> append(T t) {
        return new JsonResourceList<J, T>(this.json, this.addFn.apply(this.mirror, t), this.maker, this.setter, this.addFn);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int count = 0;

            @Override
            public boolean hasNext() {
                return this.count < JsonResourceList.this.size();
            }

            @Override
            public T next() {
                return JsonResourceList.this.get(this.count++);
            }
        };
    }

    public String toString() {
        return "JsonResourceList(json=" + this.json + ", mirror=" + this.mirror + ", asList=" + this.asList + ", maker=" + this.maker + ", setter=" + this.setter + ", addFn=" + this.addFn + ")";
    }
}

