/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.client;

import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import one.xingyi.core.client.IResourceList;
import one.xingyi.core.utils.Function3;

public class MirroredResourceList<T>
implements IResourceList<T> {
    public final ScriptObjectMirror mirror;
    private final List<Object> asList;
    private Function<Object, T> maker;
    private Function3<ScriptObjectMirror, Integer, T, ScriptObjectMirror> setter;
    private BiFunction<ScriptObjectMirror, T, ScriptObjectMirror> addFn;

    public MirroredResourceList(ScriptObjectMirror mirror, Function<Object, T> maker, Function3<ScriptObjectMirror, Integer, T, ScriptObjectMirror> setter, BiFunction<ScriptObjectMirror, T, ScriptObjectMirror> addFn) {
        this.mirror = mirror;
        this.asList = (List)mirror.to(List.class);
        this.maker = maker;
        this.setter = setter;
        this.addFn = addFn;
    }

    @Override
    public int size() {
        return this.asList.size();
    }

    @Override
    public T get(int n) {
        return this.maker.apply(this.asList.get(n));
    }

    @Override
    public IResourceList<T> withItem(int n, T t) {
        return new MirroredResourceList<T>(this.setter.apply(this.mirror, n, t), this.maker, this.setter, this.addFn);
    }

    @Override
    public IResourceList<T> append(T t) {
        return new MirroredResourceList<T>(this.addFn.apply(this.mirror, (ScriptObjectMirror)t), this.maker, this.setter, this.addFn);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int count = 0;

            @Override
            public boolean hasNext() {
                return this.count < MirroredResourceList.this.size();
            }

            @Override
            public T next() {
                return MirroredResourceList.this.get(this.count++);
            }
        };
    }

    public String toString() {
        return "MirroredResourceList(mirror=" + this.mirror + ", asList=" + this.asList + ", maker=" + this.maker + ", setter=" + this.setter + ", addFn=" + this.addFn + ")";
    }
}

