/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.codeDom;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import one.xingyi.core.annotationProcessors.ElementFail;
import one.xingyi.core.codeDom.PackageAndClassName;
import one.xingyi.core.codeDom.ViewAndCompanion;
import one.xingyi.core.names.IClassNameStrategy;
import one.xingyi.core.names.IPackageNameStrategy;
import one.xingyi.core.sdk.IXingYiCompositeDefn;
import one.xingyi.core.sdk.IXingYiView;
import one.xingyi.core.utils.Lists;
import one.xingyi.core.utils.LoggerAdapter;
import one.xingyi.core.utils.Strings;
import one.xingyi.core.validation.Result;

public class CompositeViewDom {
    public final List<ViewAndCompanion> views;
    public final PackageAndClassName originalDefn;
    public final PackageAndClassName clientResource;
    public final PackageAndClassName clientInterface;
    public final PackageAndClassName clientImpl;
    public final PackageAndClassName clientCompositeCompanion;
    static String compositeDefnName = IXingYiCompositeDefn.class.getName();

    static Result<String, ViewAndCompanion> findViewAndCompanion(Element element, TypeMirror interfaceMirror) {
        String typeAsName = interfaceMirror.toString();
        if (typeAsName.contains("<") || typeAsName.contains(">")) {
            return Result.failwith("Cannot process interface " + typeAsName + " as it is higher kinded");
        }
        try {
            Class<?> interfaceClass = Class.forName(typeAsName);
            if (!IXingYiView.class.isAssignableFrom(interfaceClass)) {
                return Result.failwith("interface " + typeAsName + " doesn't extends IXingYiView");
            }
            PackageAndClassName view = new PackageAndClassName(typeAsName);
            String rootPackage = Strings.allButLastSegment(".", view.packageName);
            PackageAndClassName companionName = new PackageAndClassName(view.packageName + "companion", view.className + "Companion");
            return Result.succeed(new ViewAndCompanion(view, companionName));
        }
        catch (Exception e) {
            return Result.failwith(e.getClass() + " " + e.getMessage());
        }
    }

    public static Result<ElementFail, CompositeViewDom> create(LoggerAdapter log, TypeElement element, IPackageNameStrategy packageNameStrategy, IClassNameStrategy classNameStrategy) {
        PackageAndClassName originaldefn = new PackageAndClassName(element.asType().toString());
        ArrayList<? extends TypeMirror> interfaces = new ArrayList<TypeMirror>(element.getInterfaces());
        String debug = Lists.mapJoin(interfaces, ",", i -> i.toString());
        Optional<TypeMirror> optCompositeInterface = Lists.find(interfaces, i -> i.toString().startsWith(compositeDefnName));
        if (optCompositeInterface.isEmpty()) {
            log.error(element, "Should extend " + compositeDefnName + "\n" + debug);
        }
        TypeMirror compInt = optCompositeInterface.get();
        interfaces.remove(compInt);
        List failsAndView = Lists.map(interfaces, i -> CompositeViewDom.findViewAndCompanion(element, i));
        List failures = Result.failures(failsAndView);
        if (failures.size() > 0) {
            return Result.failwith(new ElementFail(failures.toString(), element));
        }
        List<ViewAndCompanion> views = Result.successes(failsAndView);
        PackageAndClassName clientResource = new PackageAndClassName(Strings.extractFromOptionalEnvelope(compositeDefnName + "<", ">", compInt.toString()));
        return Result.succeed(new CompositeViewDom(views, originaldefn, clientResource, new PackageAndClassName(packageNameStrategy.toCompositeInterface(originaldefn.packageName), classNameStrategy.toCompositeInterface(originaldefn.className)), new PackageAndClassName(packageNameStrategy.toCompositeImpl(originaldefn.packageName), classNameStrategy.toCompositeImpl(originaldefn.className)), new PackageAndClassName(packageNameStrategy.toCompositeCompanion(originaldefn.packageName), classNameStrategy.toCompositeCompanion(originaldefn.className))));
    }

    public CompositeViewDom(List<ViewAndCompanion> views, PackageAndClassName originalDefn, PackageAndClassName clientResource, PackageAndClassName clientInterface, PackageAndClassName clientImpl, PackageAndClassName clientCompositeCompanion) {
        this.views = views;
        this.originalDefn = originalDefn;
        this.clientResource = clientResource;
        this.clientInterface = clientInterface;
        this.clientImpl = clientImpl;
        this.clientCompositeCompanion = clientCompositeCompanion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompositeViewDom)) {
            return false;
        }
        CompositeViewDom other = (CompositeViewDom)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ViewAndCompanion> this$views = this.views;
        List<ViewAndCompanion> other$views = other.views;
        if (this$views == null ? other$views != null : !((Object)this$views).equals(other$views)) {
            return false;
        }
        PackageAndClassName this$originalDefn = this.originalDefn;
        PackageAndClassName other$originalDefn = other.originalDefn;
        if (this$originalDefn == null ? other$originalDefn != null : !((Object)this$originalDefn).equals(other$originalDefn)) {
            return false;
        }
        PackageAndClassName this$clientResource = this.clientResource;
        PackageAndClassName other$clientResource = other.clientResource;
        if (this$clientResource == null ? other$clientResource != null : !((Object)this$clientResource).equals(other$clientResource)) {
            return false;
        }
        PackageAndClassName this$clientInterface = this.clientInterface;
        PackageAndClassName other$clientInterface = other.clientInterface;
        if (this$clientInterface == null ? other$clientInterface != null : !((Object)this$clientInterface).equals(other$clientInterface)) {
            return false;
        }
        PackageAndClassName this$clientImpl = this.clientImpl;
        PackageAndClassName other$clientImpl = other.clientImpl;
        if (this$clientImpl == null ? other$clientImpl != null : !((Object)this$clientImpl).equals(other$clientImpl)) {
            return false;
        }
        PackageAndClassName this$clientCompositeCompanion = this.clientCompositeCompanion;
        PackageAndClassName other$clientCompositeCompanion = other.clientCompositeCompanion;
        return !(this$clientCompositeCompanion == null ? other$clientCompositeCompanion != null : !((Object)this$clientCompositeCompanion).equals(other$clientCompositeCompanion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CompositeViewDom;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ViewAndCompanion> $views = this.views;
        result = result * 59 + ($views == null ? 43 : ((Object)$views).hashCode());
        PackageAndClassName $originalDefn = this.originalDefn;
        result = result * 59 + ($originalDefn == null ? 43 : ((Object)$originalDefn).hashCode());
        PackageAndClassName $clientResource = this.clientResource;
        result = result * 59 + ($clientResource == null ? 43 : ((Object)$clientResource).hashCode());
        PackageAndClassName $clientInterface = this.clientInterface;
        result = result * 59 + ($clientInterface == null ? 43 : ((Object)$clientInterface).hashCode());
        PackageAndClassName $clientImpl = this.clientImpl;
        result = result * 59 + ($clientImpl == null ? 43 : ((Object)$clientImpl).hashCode());
        PackageAndClassName $clientCompositeCompanion = this.clientCompositeCompanion;
        result = result * 59 + ($clientCompositeCompanion == null ? 43 : ((Object)$clientCompositeCompanion).hashCode());
        return result;
    }

    public String toString() {
        return "CompositeViewDom(views=" + this.views + ", originalDefn=" + this.originalDefn + ", clientResource=" + this.clientResource + ", clientInterface=" + this.clientInterface + ", clientImpl=" + this.clientImpl + ", clientCompositeCompanion=" + this.clientCompositeCompanion + ")";
    }
}

