/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.codeDom;

import java.util.Set;
import java.util.function.Function;
import one.xingyi.core.utils.Strings;

public class PackageAndClassName {
    public static PackageAndClassName StringPn = new PackageAndClassName(String.class.getName());
    public static PackageAndClassName IntegerPn = new PackageAndClassName(Integer.class.getName());
    public static PackageAndClassName DoublePn = new PackageAndClassName(Double.class.getName());
    public static PackageAndClassName BooleanPn = new PackageAndClassName(Boolean.class.getName());
    public static PackageAndClassName intPn = new PackageAndClassName(Integer.TYPE.getName());
    public static PackageAndClassName doublePn = new PackageAndClassName(Double.TYPE.getName());
    public static PackageAndClassName booleanPn = new PackageAndClassName(Boolean.TYPE.getName());
    private static Set<PackageAndClassName> rawPrimitives = null;
    public final String packageName;
    public final String className;

    public static Set<PackageAndClassName> primitives() {
        if (rawPrimitives == null) {
            rawPrimitives = Set.of(StringPn, IntegerPn, intPn, BooleanPn, booleanPn, DoublePn, doublePn);
        }
        return rawPrimitives;
    }

    public PackageAndClassName(String name) {
        this.packageName = Strings.allButLastSegment(".", name);
        this.className = name.substring(this.packageName.length() + 1);
    }

    public PackageAndClassName mapName(Function<String, String> fn) {
        return new PackageAndClassName(this.packageName, fn.apply(this.className));
    }

    public String asString() {
        return this.packageName + "." + this.className;
    }

    public String asVariableDeclaration() {
        return this.asString() + " " + this.className;
    }

    public PackageAndClassName withName(String name) {
        return new PackageAndClassName(this.packageName, name);
    }

    public String toString() {
        return "PackageAndClassName(packageName=" + this.packageName + ", className=" + this.className + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PackageAndClassName)) {
            return false;
        }
        PackageAndClassName other = (PackageAndClassName)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$packageName = this.packageName;
        String other$packageName = other.packageName;
        if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
            return false;
        }
        String this$className = this.className;
        String other$className = other.className;
        return !(this$className == null ? other$className != null : !this$className.equals(other$className));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PackageAndClassName;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $packageName = this.packageName;
        result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
        String $className = this.className;
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        return result;
    }

    public PackageAndClassName(String packageName, String className) {
        this.packageName = packageName;
        this.className = className;
    }
}

