/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.endpoints;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import one.xingyi.core.endpoints.MethodAndPathDescription;
import one.xingyi.core.endpoints.ResourceEndpointFnFromAcceptor;
import one.xingyi.core.endpoints.ResourceEndpointNoFromAcceptor;
import one.xingyi.core.endpoints.ResourceWithFromEndpointAcceptor;
import one.xingyi.core.endpoints.SuccessfulMatch;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.utils.Optionals;

public interface IResourceEndpointAcceptor<From>
extends Function<ServiceRequest, Optional<From>>,
MethodAndPathDescription {
    public static <From> IResourceEndpointAcceptor<From> apply(String method, String templatedPath, BiFunction<ServiceRequest, String, From> fromFn, String description) {
        return new ResourceWithFromEndpointAcceptor<From>(method, templatedPath, fromFn, description);
    }

    public static IResourceEndpointAcceptor<SuccessfulMatch> apply(String method, String templatedPath, String description) {
        return new ResourceEndpointNoFromAcceptor(method, templatedPath, description);
    }

    public static <Req> IResourceEndpointAcceptor<Req> create(String method, String path, Function<ServiceRequest, Req> reqFn, String description) {
        return new ResourceEndpointFnFromAcceptor<Req>(method, path, reqFn, description);
    }

    public String method();

    public String templatedPath();

    default public <T> Function<ServiceRequest, CompletableFuture<Optional<T>>> andIfMatches(Function<From, CompletableFuture<T>> fn) {
        return sr -> Optionals.fold((Optional)this.apply(sr), () -> CompletableFuture.completedFuture(Optional.empty()), from -> ((CompletableFuture)fn.apply(from)).thenApply(t -> Optional.of(t)));
    }
}

