/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.endpoints;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import one.xingyi.core.endpoints.IMediaTypeEndpoint;
import one.xingyi.core.endpoints.IResourceEndpointAcceptor;
import one.xingyi.core.endpoints.MethodPathAndDescription;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.http.ServiceResponse;
import one.xingyi.core.marshelling.ContextForJson;
import one.xingyi.core.mediatype.IMediaTypeServerDefn;
import one.xingyi.core.sdk.IXingYiResource;
import one.xingyi.core.utils.IdAndValue;
import one.xingyi.core.utils.Optionals;

public class IdAndEntityMediaTypeEndpoint<Request, Entity extends IXingYiResource>
implements IMediaTypeEndpoint<Request, Entity> {
    final IResourceEndpointAcceptor<Request> acceptor;
    final Function<Request, CompletableFuture<IdAndValue<Entity>>> fn;
    final String protocol;
    final int statusCode;
    final IMediaTypeServerDefn<Entity> mediaType;
    final Function<Entity, String> stateFn;

    @Override
    public List<MethodPathAndDescription> description() {
        return this.acceptor.description();
    }

    @Override
    public CompletableFuture<Optional<ServiceResponse>> apply(ServiceRequest serviceRequest) {
        return Optionals.flip(((Optional)this.acceptor.apply(serviceRequest)).map(request -> this.fn.apply(request).thenApply(this.makeServiceResponse(serviceRequest))));
    }

    Function<IdAndValue<Entity>, ServiceResponse> makeServiceResponse(ServiceRequest serviceRequest) {
        ContextForJson context = ContextForJson.forServiceRequest(this.protocol, serviceRequest);
        return idAndvalue -> new ServiceResponse(this.statusCode, this.mediaType.makeDataAndDefn(context, this.stateFn, (IdAndValue<Entity>)idAndvalue).asString(), List.of());
    }

    public IdAndEntityMediaTypeEndpoint(IResourceEndpointAcceptor<Request> acceptor, Function<Request, CompletableFuture<IdAndValue<Entity>>> fn, String protocol, int statusCode, IMediaTypeServerDefn<Entity> mediaType, Function<Entity, String> stateFn) {
        this.acceptor = acceptor;
        this.fn = fn;
        this.protocol = protocol;
        this.statusCode = statusCode;
        this.mediaType = mediaType;
        this.stateFn = stateFn;
    }
}

