/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.endpoints;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import one.xingyi.core.endpoints.IResourceEndpointAcceptor;
import one.xingyi.core.endpoints.MethodPathAndDescription;
import one.xingyi.core.http.ServiceRequest;

class ResourceEndpointFnFromAcceptor<From>
implements IResourceEndpointAcceptor<From> {
    final String method;
    final String path;
    final Function<ServiceRequest, From> reqFn;
    final String description;
    final String templatedPath;

    public ResourceEndpointFnFromAcceptor(String method, String templatedPath, Function<ServiceRequest, From> reqFn, String description) {
        this.method = method;
        this.templatedPath = templatedPath;
        this.path = templatedPath.replace("{host}", "");
        this.reqFn = reqFn;
        this.description = description;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public String templatedPath() {
        return this.templatedPath;
    }

    @Override
    public Optional<From> apply(ServiceRequest serviceRequest) {
        if (this.method.equalsIgnoreCase(serviceRequest.method) && this.path.equalsIgnoreCase(serviceRequest.path)) {
            return Optional.of(this.reqFn.apply(serviceRequest));
        }
        return Optional.empty();
    }

    @Override
    public List<MethodPathAndDescription> description() {
        return List.of(new MethodPathAndDescription(this.method, this.templatedPath, this.description));
    }
}

