/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.endpoints;

import java.util.List;
import java.util.Optional;
import one.xingyi.core.endpoints.IResourceEndpointAcceptor;
import one.xingyi.core.endpoints.MethodPathAndDescription;
import one.xingyi.core.endpoints.SuccessfulMatch;
import one.xingyi.core.http.ServiceRequest;

class ResourceEndpointNoFromAcceptor
implements IResourceEndpointAcceptor<SuccessfulMatch> {
    final String method;
    final String path;
    private String description;
    private final String originalPath;

    public ResourceEndpointNoFromAcceptor(String method, String path, String description) {
        this.method = method;
        this.originalPath = path;
        this.path = path.replace("{host}", "");
        this.description = description;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public String templatedPath() {
        return this.path;
    }

    @Override
    public Optional<SuccessfulMatch> apply(ServiceRequest serviceRequest) {
        if (!serviceRequest.method.equalsIgnoreCase(this.method)) {
            return Optional.empty();
        }
        if (!serviceRequest.uri.getPath().equalsIgnoreCase(this.path)) {
            return Optional.empty();
        }
        return SuccessfulMatch.optMatch;
    }

    @Override
    public List<MethodPathAndDescription> description() {
        return List.of(new MethodPathAndDescription(this.method, this.originalPath, this.description));
    }
}

