/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.endpoints;

import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import one.xingyi.core.endpoints.IResourceEndpointAcceptor;
import one.xingyi.core.endpoints.MethodPathAndDescription;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.utils.Strings;

class ResourceWithFromEndpointAcceptor<From>
implements IResourceEndpointAcceptor<From> {
    final String method;
    final String templatedPath;
    final Function<String, Optional<String>> ripper;
    final BiFunction<ServiceRequest, String, From> fromFn;
    private String description;

    public ResourceWithFromEndpointAcceptor(String method, String templatedPath, BiFunction<ServiceRequest, String, From> fromFn, String description) {
        this.method = method;
        this.templatedPath = templatedPath;
        this.ripper = Strings.ripIdFromPath(templatedPath.replace("{host}", ""));
        this.fromFn = fromFn;
        this.description = description;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public String templatedPath() {
        return this.templatedPath;
    }

    @Override
    public Optional<From> apply(ServiceRequest serviceRequest) {
        if (!serviceRequest.method.equalsIgnoreCase(this.method)) {
            return Optional.empty();
        }
        return this.ripper.apply(serviceRequest.uri.getPath()).map(id -> this.fromFn.apply(serviceRequest, (String)id));
    }

    @Override
    public List<MethodPathAndDescription> description() {
        return List.of(new MethodPathAndDescription(this.method, this.templatedPath, this.description));
    }
}

