/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.filemaker;

import java.util.List;
import one.xingyi.core.annotations.XingYiGenerated;
import one.xingyi.core.codeDom.PackageAndClassName;
import one.xingyi.core.codeDom.ResourceDom;
import one.xingyi.core.filemaker.FileDefn;
import one.xingyi.core.filemaker.IFileMaker;
import one.xingyi.core.sdk.IXingYiClientResource;
import one.xingyi.core.utils.Formating;
import one.xingyi.core.utils.Lists;
import one.xingyi.core.utils.Strings;
import one.xingyi.core.validation.Result;

public class ClientResourceFileMaker
implements IFileMaker<ResourceDom> {
    @Override
    public Result<String, FileDefn> apply(ResourceDom resourceDom) {
        PackageAndClassName clientResourceName = resourceDom.entityNames.clientResource;
        String result = Lists.join(Lists.append(Formating.javaFile(this.getClass(), resourceDom.deprecated, clientResourceName, "interface", clientResourceName, " extends IXingYiClientResource", List.of(), IXingYiClientResource.class, XingYiGenerated.class), Formating.indent(this.addBookmark(resourceDom)), Formating.indent(this.addPrototypeId(resourceDom)), List.of("}")), "\n");
        return Result.succeed(new FileDefn(clientResourceName, result));
    }

    private List<String> addBookmark(ResourceDom resourceDom) {
        if (resourceDom.bookmark.isEmpty()) {
            return List.of();
        }
        return List.of("final String bookmark=" + Strings.quote(resourceDom.bookmark.get().bookmark) + ";");
    }

    private List<String> addPrototypeId(ResourceDom resourceDom) {
        if (resourceDom.actionsDom.prototypeDom.isEmpty()) {
            return List.of();
        }
        return List.of("final String prototypeId=" + Strings.quote(resourceDom.actionsDom.prototypeDom.get().prototypeId) + ";");
    }
}

