/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.filemaker;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import one.xingyi.core.annotations.XingYiGenerated;
import one.xingyi.core.client.IResourceList;
import one.xingyi.core.codeDom.ResourceDom;
import one.xingyi.core.endpoints.BookmarkCodeAndUrlPattern;
import one.xingyi.core.endpoints.EndPoint;
import one.xingyi.core.endpoints.EndpointContext;
import one.xingyi.core.endpoints.HasBookmarkAndUrl;
import one.xingyi.core.filemaker.FileDefn;
import one.xingyi.core.filemaker.IFileMaker;
import one.xingyi.core.marshelling.JsonParser;
import one.xingyi.core.mediatype.IResourceEndpoints;
import one.xingyi.core.mediatype.IXingYiServerMediaTypeDefn;
import one.xingyi.core.mediatype.JsonAndLensDefnServerMediaTypeDefn;
import one.xingyi.core.mediatype.ServerMediaTypeContext;
import one.xingyi.core.optics.lensLanguage.LensLine;
import one.xingyi.core.optics.lensLanguage.ListLensDefn;
import one.xingyi.core.optics.lensLanguage.StringLensDefn;
import one.xingyi.core.optics.lensLanguage.ViewLensDefn;
import one.xingyi.core.sdk.IXingYiServerCompanion;
import one.xingyi.core.sdk.IXingYiServesResourceCompanion;
import one.xingyi.core.state.EntityDomToStateMap;
import one.xingyi.core.state.StateData;
import one.xingyi.core.utils.Formating;
import one.xingyi.core.utils.Lists;
import one.xingyi.core.utils.Optionals;
import one.xingyi.core.utils.Sets;
import one.xingyi.core.utils.Strings;
import one.xingyi.core.validation.Result;

public class ServerCompanionFileMaker
implements IFileMaker<ResourceDom> {
    List<String> createBookmarkAndUrl(ResourceDom resourceDom) {
        return Optionals.fold(resourceDom.bookmark, () -> List.of(), b -> List.of("@Override public BookmarkCodeAndUrlPattern bookmarkAndUrl(){return new BookmarkCodeAndUrlPattern(" + Strings.quote(b.bookmark) + "," + Strings.quote(b.urlPattern) + "," + Strings.quote(b.code) + ");}"));
    }

    private List<String> createCompanion(ResourceDom resourceDom) {
        return List.of("public static " + resourceDom.entityNames.serverCompanion.asString() + " companion  =new " + resourceDom.entityNames.serverCompanion.className + "();");
    }

    private List<String> createJavascript(ResourceDom resourceDom) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("public String javascript(){return javascript;}");
        result.add("final public String javascript = " + Strings.quote(""));
        result.addAll(Formating.indent(resourceDom.fields.withDeprecatedmap(fd -> "+ " + Strings.quote(fd.javascript + "\\n"))));
        result.add(";");
        return result;
    }

    private List<String> createMediaDefn(ResourceDom resourceDom) {
        if (resourceDom.bookmark.isPresent()) {
            String entityName = resourceDom.entityNames.serverEntity.className;
            return List.of(" public <J>IXingYiServerMediaTypeDefn<" + resourceDom.entityNames.serverEntity.className + "> lensMediaDefn(ServerMediaTypeContext<J> context) {", "    return new JsonAndLensDefnServerMediaTypeDefn<>(" + Strings.quote(entityName) + ", this, context, lensLines());", " }");
        }
        return List.of();
    }

    private List<String> createListOfLens(ResourceDom resourceDom) {
        return List.of("public List<String> lens(){return List.of(", resourceDom.fields.withDeprecatedmapJoin(",", fd -> Strings.quote(fd.lensName)), ");}");
    }

    private List<String> createLensDefn(ResourceDom resourceDom) {
        return List.of("public List<String> lensLines(){return List.of(", "    " + resourceDom.fields.withDeprecatedmapJoin(",\n        ", fd -> Strings.quote(fd.lensName + "=" + fd.lensPath)), ");}");
    }

    List<String> fromJson(ResourceDom dom) {
        String className = dom.entityNames.serverEntity.className;
        return List.of("@XingYiGenerated", "public <J> " + className + " fromJson(JsonParser<J> jsonParser, J j){", "    return new " + className + "(" + dom.fields.noDeprecatedmapJoin(",\n        ", fd -> fd.typeDom.forFromJson(fd.name)) + ");", "};");
    }

    String bookmarkAndCode(BookmarkCodeAndUrlPattern b) {
        return Strings.quote(b.urlPattern) + "," + Strings.quote(b.code);
    }

    List<String> createWithNoIdEndpoint(String methodName, String method, String controllerName, BookmarkCodeAndUrlPattern bookmark, String reqFn, String function, String stateFn) {
        return Lists.append(List.of("public <J>EndPoint " + methodName + "(EndpointContext<J> context, " + controllerName + " controller) {", "    return EndPoint." + method + "(context, " + this.bookmarkAndCode(bookmark) + ", " + reqFn + "," + function + "," + stateFn + ");", "}"));
    }

    List<String> createEndpointWithStateFn(String methodName, String method, String controllerName, BookmarkCodeAndUrlPattern bookmark, String function, String stateFn) {
        return Lists.append(List.of("public <J>EndPoint " + methodName + "(EndpointContext<J> context, " + controllerName + " controller) {", "    return EndPoint." + method + "(context, " + this.bookmarkAndCode(bookmark) + ", " + function + "," + stateFn + ");", "}"));
    }

    List<String> deleteEndpoint(String methodName, String method, String controllerName, BookmarkCodeAndUrlPattern bookmark, String function) {
        return Lists.append(List.of("public <J>EndPoint " + methodName + "(EndpointContext<J> context, " + controllerName + " controller) {", "    return EndPoint." + method + "(context, " + Strings.quote(bookmark.urlPattern) + ", " + function + ");", "}"));
    }

    List<String> createPutEndpoint(String methodName, String companionName, String controllerName, BookmarkCodeAndUrlPattern bookmark, String function, String stateFn) {
        return Lists.append(List.of("public <J>EndPoint " + methodName + "(EndpointContext<J> context, " + controllerName + " controller) {", "    return EndPoint.putEntity(" + companionName + ".companion, context, " + this.bookmarkAndCode(bookmark) + ", " + function + "," + stateFn + ");", "}"));
    }

    List<String> createPostEndpoint(String methodName, List<String> states, String controllerName, BookmarkCodeAndUrlPattern bookmark, String function, String stateFn) {
        return Lists.append(List.of("public <J> EndPoint " + methodName + "(EndpointContext<J> context, " + controllerName + " controller) {", "    return EndPoint.postEntity(context, " + this.bookmarkAndCode(bookmark) + ", List.of(" + Lists.mapJoin(states, ",", Strings::quote) + ")," + function + "," + stateFn + ");", "}"));
    }

    List<String> createEntityEndpoint(ResourceDom resourceDom) {
        return List.of("public <J>EndPoint entityEndpoint(EndpointContext<J> context,List<HasBookmarkAndUrl> companions){ return EndPointFactorys.<J>entityEndpointFromContext(context,companions);}", "public  <J>EndPoint entityCodeEndpoint(EndpointContext<J> context){ return  EndPoint.javascript(context, \"{host}/resource/code\");}");
    }

    List<String> createCodeEndpoint(ResourceDom resourceDom) {
        if (resourceDom.bookmark.isPresent()) {
            return List.of("public <J> EndPoint " + resourceDom.entityNames.serverEntity.className + "codeEndpoint(EndpointContext<J> context) {return EndPoint.javascript(context, " + Strings.quote(resourceDom.bookmark.get().code) + ");}");
        }
        return List.of();
    }

    List<String> createEndpoints(ResourceDom resourceDom) {
        String className = resourceDom.entityNames.serverEntity.className;
        if (resourceDom.bookmark.isPresent()) {
            return List.of("public <J> IResourceEndpoints<" + className + "> endpoints(ServerMediaTypeContext<J> context, Function<" + className + ", String> stateFn) {", "    return lensMediaDefn(context).endpoints(context.protocol(), bookmarkAndUrl(), stateFn);", "}");
        }
        return List.of();
    }

    @Override
    public Result<String, FileDefn> apply(ResourceDom resourceDom) {
        String implementsString = (resourceDom.bookmark.isEmpty() ? "IXingYiServerCompanion" : "IXingYiServesResourceCompanion") + "<" + resourceDom.entityNames.originalDefn.asString() + "," + resourceDom.entityNames.serverEntity.asString() + ">";
        String result = Lists.join(Lists.append(Formating.javaFile(this.getClass(), resourceDom.deprecated, resourceDom.entityNames.originalDefn, "class", resourceDom.entityNames.serverCompanion, " implements " + implementsString, List.of(resourceDom.entityNames.serverEntity.asString(), resourceDom.entityNames.serverController.asString(), "one.xingyi.core.EndPointFactorys", "one.xingyi.core.httpClient.server.controller.IResourceDetailsController"), IXingYiServerCompanion.class, JsonParser.class, Map.class, StateData.class, List.class, IResourceList.class, Lists.class, IXingYiServesResourceCompanion.class, XingYiGenerated.class, EndPoint.class, EndpointContext.class, Optional.class, BookmarkCodeAndUrlPattern.class, HasBookmarkAndUrl.class, ServerMediaTypeContext.class, JsonAndLensDefnServerMediaTypeDefn.class, LensLine.class, StringLensDefn.class, ViewLensDefn.class, ListLensDefn.class, IXingYiServerMediaTypeDefn.class, IResourceEndpoints.class, Function.class), Formating.indent(this.createBookmarkAndUrl(resourceDom)), Formating.indent(this.createEndpoints(resourceDom)), Formating.indent(this.createCodeEndpoint(resourceDom)), Formating.indent(this.createEntityEndpoint(resourceDom)), Formating.indent(this.createCompanion(resourceDom)), Formating.indent(this.createJavascript(resourceDom)), Formating.indent(this.createListOfLens(resourceDom)), Formating.indent(this.createMediaDefn(resourceDom)), Formating.indent(this.createLensDefn(resourceDom)), Formating.indent(this.fromJson(resourceDom)), Formating.indent(this.stateMap(resourceDom)), List.of("}")), "\n");
        return Result.succeed(new FileDefn(resourceDom.entityNames.serverCompanion, result));
    }

    private List<String> stateMap(ResourceDom resourceDom) {
        Map statemap = (Map)EntityDomToStateMap.simple.apply(resourceDom);
        return List.of("public final Map<String,List<StateData>> stateMap=Map.of(", "    " + Lists.mapJoin(Sets.sortedList(statemap.keySet(), String::compareTo), ",\n        ", stateName -> Strings.quote(stateName) + ", List.of(" + Lists.mapJoin((List)statemap.get(stateName), ",", sd -> "new StateData(" + Strings.quote(sd.action) + "," + Strings.quote(sd.link) + "))")), ");");
    }
}

