/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.filemaker;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import one.xingyi.core.annotations.XingYiGenerated;
import one.xingyi.core.codeDom.ServerDom;
import one.xingyi.core.endpoints.BookmarkCodeAndUrlPattern;
import one.xingyi.core.endpoints.EndPoint;
import one.xingyi.core.endpoints.EndpointConfig;
import one.xingyi.core.endpoints.EndpointContext;
import one.xingyi.core.endpoints.HasBookmarkAndUrl;
import one.xingyi.core.filemaker.FileDefn;
import one.xingyi.core.filemaker.IFileMaker;
import one.xingyi.core.marshelling.JsonValue;
import one.xingyi.core.marshelling.JsonWriter;
import one.xingyi.core.sdk.IXingYiServer;
import one.xingyi.core.sdk.IXingYiServerCompanion;
import one.xingyi.core.server.EndpointHandler;
import one.xingyi.core.server.SimpleServer;
import one.xingyi.core.utils.Files;
import one.xingyi.core.utils.Formating;
import one.xingyi.core.utils.IdAndValue;
import one.xingyi.core.utils.Lists;
import one.xingyi.core.utils.Optionals;
import one.xingyi.core.utils.Strings;
import one.xingyi.core.validation.Result;

public class ServerFileMaker
implements IFileMaker<ServerDom> {
    List<String> makeCompanions(ServerDom serverDom) {
        return List.of("public List<IXingYiServerCompanion<?, ?>> companions() {return List.of(", "    " + Lists.mapJoin(serverDom.codeDom.resourceDoms, ",", ed -> ed.entityNames.serverCompanion.asString()) + ");}");
    }

    List<String> createFields(ServerDom serverDom) {
        return Lists.append(List.of("public final EndpointContext<J> context;"), Lists.collect(serverDom.codeDom.resourceDoms, ed -> ed.bookmark.isPresent(), ed -> "public final " + ed.entityNames.serverController.asString() + " " + ed.entityNames.serverController.className + ";"));
    }

    List<String> createConstructor(ServerDom serverDom) {
        return Lists.append(List.of("public " + serverDom.serverName.className + "(EndpointConfig<J> config," + Lists.collectJoin(serverDom.codeDom.resourceDoms, ",", ed -> ed.bookmark.isPresent(), ed -> ed.entityNames.serverController.asVariableDeclaration()) + "){// A compilation error here is often caused by incremental compilation. It might also be because there are no bookmarked/rootUrl resouces (see the @Resource annotation)", "    this.context = config.from(companions());"), Formating.indent(Lists.collect(serverDom.codeDom.resourceDoms, ed -> ed.bookmark.isPresent(), ed -> "this." + ed.entityNames.serverController.className + " = " + ed.entityNames.serverController.className + ";")), List.of("}"));
    }

    List<String> createCompanions(ServerDom serverDom) {
        return List.of("public List<IXingYiServerCompanion<?, ?>> companions(){return List.of(", "    one.xingyi.core.httpClient.server.companion.ResourceDetailsCompanion.companion,//added for url pattern on original bookmark ", "    " + Lists.mapJoin(serverDom.codeDom.resourceDoms, ",", ed -> ed.entityNames.serverCompanion.asString() + ".companion"), ");}");
    }

    List<String> createLens(ServerDom serverDom) {
        return List.of("public List<String> lens(){return Lists.flatMap(companions(), c->c.lens());}");
    }

    List<String> createEntityCompanions(ServerDom serverDom) {
        return List.of("public List<HasBookmarkAndUrl> entityCompanions(){return List.of(", "    " + Lists.mapJoin(Lists.filter(serverDom.codeDom.resourceDoms, e -> e.bookmark.isPresent()), ",", ed -> ed.entityNames.serverCompanion.asString() + ".companion"), ");}");
    }

    String bookmarkAndCode(BookmarkCodeAndUrlPattern b) {
        return Strings.quote(b.urlPattern) + "," + Strings.quote(b.code);
    }

    List<String> createWithNoIdEndpoint(String entityName, String path, String companion, String fromFn, String function, String stateFn) {
        return Lists.append(List.of("public EndPoint createWithNoId" + entityName + "() {", "    return " + companion + ".companion.endpoints(context, " + stateFn + ").createWithoutId(" + Strings.quote(path) + "," + fromFn + "," + function + ");", "}"));
    }

    List<String> createEndpointWithStateFn(String entityName, String companion, String function, String stateFn) {
        return Lists.append(List.of("public EndPoint createWithId" + entityName + "() {", "     return " + companion + ".companion.endpoints(context, " + stateFn + ").createWithId(" + function + ");", "}"));
    }

    List<String> getEndpointWithStateFn(String entityName, String method, String companion, String function, String stateFn) {
        return Lists.append(List.of("public EndPoint " + method + entityName + "() {", "     return " + companion + ".companion.endpoints(context, " + stateFn + ")." + method + "(" + function + ");", "}"));
    }

    List<String> createEndpoint(String methodName, String method, BookmarkCodeAndUrlPattern bookmark, String function) {
        return Lists.append(List.of("public EndPoint " + methodName + "() {", "    return EndPoint." + method + "(context, " + this.bookmarkAndCode(bookmark) + ", " + function + ");", "}"));
    }

    List<String> deleteEndpoint(String entityName, String companion, String function, String stateFn) {
        return List.of("public EndPoint delete" + entityName + "() {", "    return " + companion + ".companion.endpoints(context, " + stateFn + ").delete(" + function + ");", "}");
    }

    List<String> createPutEndpoint(String className, String companionName, String function, String stateFn) {
        return List.of("public EndPoint put" + className + "() {", "    return " + companionName + ".companion.endpoints(context, " + stateFn + ").put(", "        (sr, id) -> new IdAndValue<>(id, " + companionName + ".companion.fromJson(context.parserAndWriter, context.parserAndWriter.parse(sr.body))), " + function + ");", "}");
    }

    List<String> createPostEndpoint(String postName, String url, String companionName, String function, String stateFn, List<String> states) {
        return Lists.append(List.of("public EndPoint " + postName + "() {", "    return " + companionName + ".companion.endpoints(context, " + stateFn + ").", "    post(" + Strings.quote(url) + ", List.of(" + Lists.mapJoin(states, ",", Strings::quote) + ")," + function + ");", "}"));
    }

    List<String> createEntityEndpoint(ServerDom serverDom) {
        return List.of("//A compilation error here might be because you haven't added a maven dependency to the 'core' jar", "public EndPoint entityEndpoint(){ return new ResourceDefinitionEndPoint(context,entityCompanions());}");
    }

    List<String> createCodeEndpoint(ServerDom serverDom) {
        return Lists.map(serverDom.codeDom.servedresourceDoms, rd -> "public EndPoint " + rd.entityNames.serverEntity.className + "codeEndpoint() {return EndPoint.javascript(context, " + Strings.quote(rd.bookmark.get().code) + ");}");
    }

    List<String> createEndpoints(ServerDom serverDom) {
        return Lists.flatMap(serverDom.codeDom.resourceDoms, ed -> {
            String className = ed.entityNames.serverEntity.className;
            String controllerName = ed.entityNames.serverController.className;
            String companionName = ed.entityNames.serverCompanion.className;
            return Optionals.fold(ed.bookmark, () -> List.of(), b -> Lists.append(List.of("//EntityDom: " + ed.bookmark), Optionals.flatMap(ed.actionsDom.createDom, dom -> this.createEndpointWithStateFn(className, companionName, controllerName + "::createWithId", controllerName + "::stateFn")), Optionals.flatMap(ed.actionsDom.createWithoutIdDom, dom -> this.createWithNoIdEndpoint(className, dom.path, companionName, controllerName + "::createWithoutIdRequestFrom", controllerName + "::createWithoutId", controllerName + "::stateFn")), Optionals.flatMap(ed.actionsDom.putDom, dom -> this.createPutEndpoint(className, companionName, controllerName + "::put", controllerName + "::stateFn")), Optionals.flatMap(ed.actionsDom.optionalGetDom, dom -> this.getEndpointWithStateFn(className, "getOptional", companionName, controllerName + "::getOptional", controllerName + "::stateFn")), Optionals.flatMapif(ed.actionsDom.getDom, ed.actionsDom.optionalGetDom.isEmpty(), dom -> this.getEndpointWithStateFn(className, "get", companionName, controllerName + "::get", controllerName + "::stateFn")), Optionals.flatMap(ed.actionsDom.deleteDom, dom -> this.deleteEndpoint(className, companionName, controllerName + "::delete", controllerName + "::stateFn")), Lists.flatMap(ed.actionsDom.postDoms, dom -> this.createPostEndpoint(dom.action + className, b.withMoreUrl((String)dom.path).urlPattern, companionName, controllerName + "::" + dom.action, controllerName + "::stateFn", dom.states))));
        });
    }

    @Override
    public Result<String, FileDefn> apply(ServerDom serverDom) {
        List<String> manualImports = Lists.append(Lists.map(serverDom.codeDom.resourceDoms, rd -> rd.entityNames.serverCompanion.asString()), List.of("one.xingyi.core.ResourceDefinitionEndPoint  /* A compile error here might be because you haven't included the maven dependency for 'org.xingyi.core' */"));
        String result = Lists.join(Lists.append(Formating.javaFile(this.getClass(), false, serverDom.originalDefn, "class", serverDom.serverName, "<J> implements IXingYiServer", manualImports, XingYiGenerated.class, EndPoint.class, List.class, Lists.class, EndpointConfig.class, EndpointContext.class, IXingYiServer.class, ExecutorService.class, SimpleServer.class, Executors.class, EndpointHandler.class, IXingYiServerCompanion.class, JsonValue.class, JsonWriter.class, Files.class, HasBookmarkAndUrl.class, IdAndValue.class), Formating.indent(this.createFields(serverDom)), Formating.indent(this.createConstructor(serverDom)), Formating.indent(this.createEntityCompanions(serverDom)), Formating.indent(this.createCompanions(serverDom)), Formating.indent(this.createEntityEndpoint(serverDom)), Formating.indent(this.createCodeEndpoint(serverDom)), Formating.indent(this.createEndpoints(serverDom)), Formating.indent(this.createLens(serverDom)), List.of("/*" + serverDom), List.of("//entities"), Formating.indent(Lists.map(serverDom.codeDom.resourceDoms, Objects::toString)), List.of("*/"), List.of("}")), "\n");
        return Result.succeed(new FileDefn(serverDom.serverName, result));
    }
}

