/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.filemaker;

import java.util.List;
import one.xingyi.core.codeDom.PackageAndClassName;
import one.xingyi.core.codeDom.ResourceDom;
import one.xingyi.core.codeDom.ViewDom;
import one.xingyi.core.codeDom.ViewDomAndItsResourceDom;
import one.xingyi.core.filemaker.AbstractDebugFileMaker;
import one.xingyi.core.filemaker.FileDefn;
import one.xingyi.core.filemaker.IFileMaker;
import one.xingyi.core.names.ViewNames;
import one.xingyi.core.utils.Formating;
import one.xingyi.core.utils.Lists;
import one.xingyi.core.utils.Optionals;
import one.xingyi.core.validation.Result;

public class ViewDomDebugFileMaker
extends AbstractDebugFileMaker
implements IFileMaker<ViewDomAndItsResourceDom> {
    List<String> viewNameInfo(ViewNames names) {
        return Lists.append(List.of("Original: " + names.originalDefn.asString()), Formating.indent(List.of("Entity:     " + names.clientEntity.asString(), "View:        " + names.clientView.asString(), "Impl   :    " + names.clientViewImpl.asString(), "ServerImpl: " + names.clientCompanion.asString())), Formating.indent(this.entityNameInfo(names.entityNames)));
    }

    List<String> viewDebugInfo(ViewDom viewDom) {
        return Lists.append(List.of("Deprecated: " + viewDom.deprecated), this.viewNameInfo(viewDom.viewNames), List.of("Fields: " + viewDom.fields.allFields.size()), Formating.indent(Lists.flatMap(viewDom.fields.allFields, this::fieldDebugInfo)));
    }

    @Override
    public Result<String, FileDefn> apply(ViewDomAndItsResourceDom viewDomAndItsResourceDom) {
        ViewDom viewDom = viewDomAndItsResourceDom.viewDom;
        PackageAndClassName packageAndClassName = viewDom.viewNames.clientView.mapName(e -> e + "DebugInfo");
        List<String> manualImports = Lists.unique(viewDom.fields.withDeprecatedmap(fd -> fd.typeDom.nested().fullTypeName()));
        List result = Lists.append(Formating.javaFile(this.getClass(), viewDom.deprecated, viewDom.viewNames.originalDefn, "class", packageAndClassName, "", manualImports, new Class[0]), List.of("/*"), this.viewDebugInfo(viewDom), List.of(""), Optionals.fold(viewDomAndItsResourceDom.entityDom, () -> List.of("Entity Dom not found"), ed -> this.entityDebugInfo((ResourceDom)ed)), viewDomAndItsResourceDom.entityDom.map(ed -> this.actionsDomInfo(ed.actionsDom)).orElse(List.of()), List.of("*/}"));
        return Result.succeed(new FileDefn(packageAndClassName, Lists.join(result, "\n")));
    }
}

