/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.http;

import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import one.xingyi.core.http.Header;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.http.ServiceResponse;
import one.xingyi.core.http.SimpleHttpClient;
import one.xingyi.core.utils.Lists;

public interface JavaHttpClient {
    public static final HttpClient httpClient = HttpClient.newHttpClient();
    public static final Function<HttpRequest, CompletableFuture<HttpResponse<String>>> service = req -> httpClient.sendAsync((HttpRequest)req, HttpResponse.BodyHandlers.ofString());
    public static final Function<ServiceRequest, HttpRequest> toJavaHttp = sr -> {
        try {
            HttpRequest.Builder b1 = HttpRequest.newBuilder().method(sr.method, HttpRequest.BodyPublishers.ofString(sr.body)).uri(sr.uri);
            HttpRequest.Builder b2 = Lists.foldLeft(b1, sr.headers, (b, h) -> b.header(h.name, h.value));
            return b2.build();
        }
        catch (Exception e) {
            throw new RuntimeException("Trying to use Java XingYiHttpClient with " + sr, e);
        }
    };
    public static final Function<HttpResponse<String>, ServiceResponse> toServiceResponse = hr -> {
        ArrayList<Header> headers = new ArrayList<Header>();
        for (Map.Entry<String, List<String>> e : hr.headers().map().entrySet()) {
            for (String value : e.getValue()) {
                headers.add(new Header(e.getKey(), value));
            }
        }
        return new ServiceResponse(hr.statusCode(), (String)hr.body(), headers);
    };
    public static final Function<ServiceRequest, CompletableFuture<ServiceResponse>> client = new SimpleHttpClient<HttpRequest, HttpResponse<String>>(service, toJavaHttp, toServiceResponse);
}

