/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.marshelling;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import one.xingyi.core.client.IXingYi;
import one.xingyi.core.client.IXingYiFactory;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.http.ServiceResponse;
import one.xingyi.core.marshelling.DataToBeSentToClient;
import one.xingyi.core.marshelling.SimpleXingYiResponseSplitter;
import one.xingyi.core.marshelling.UnexpectedResponse;
import one.xingyi.core.marshelling.XingYiResponseSplitter;
import one.xingyi.core.sdk.IXingYiClientResource;
import one.xingyi.core.sdk.IXingYiRemoteAccessDetails;
import one.xingyi.core.sdk.IXingYiView;

public interface IXingYiResponseSplitter
extends Function<ServiceResponse, CompletableFuture<DataToBeSentToClient>> {
    public static final String marker = "\n---------\n";
    public static final IXingYiResponseSplitter inLineOnlySplitter = new SimpleXingYiResponseSplitter();

    public static IXingYiResponseSplitter splitter(Function<ServiceRequest, CompletableFuture<ServiceResponse>> service) {
        return new XingYiResponseSplitter(service);
    }

    public static DataToBeSentToClient rawSplit(ServiceResponse serviceResponse) {
        if (serviceResponse.statusCode >= 300) {
            throw new UnexpectedResponse(serviceResponse);
        }
        String body = serviceResponse.body;
        return IXingYiResponseSplitter.rawSplitString(body, () -> new UnexpectedResponse("no marker found", serviceResponse));
    }

    public static DataToBeSentToClient rawSplitString(String body, Supplier<RuntimeException> exceptionSupplier) {
        int index = body.indexOf(marker);
        if (index == -1) {
            throw exceptionSupplier.get();
        }
        String javascript = body.substring(0, index);
        String data = body.substring(index + marker.length());
        return new DataToBeSentToClient(data, javascript);
    }

    public static <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>, Result> CompletableFuture<Result> fromServiceResponse(IXingYiFactory factory, IXingYiResponseSplitter splitter, IXingYiRemoteAccessDetails<Entity, View> clientMaker, ServiceRequest serviceRequest, ServiceResponse serviceResponse, Function<View, Result> resultFn) {
        try {
            return ((CompletableFuture)splitter.apply(serviceResponse)).thenApply(dataAndJavaScript -> {
                try {
                    IXingYi xingYi = factory.apply(dataAndJavaScript.defn);
                    Object mirror = xingYi.parse(dataAndJavaScript.data);
                    return resultFn.apply(clientMaker.make(xingYi, mirror));
                }
                catch (Exception e) {
                    throw new RuntimeException("Have thrown unexpected exception.\n" + serviceRequest + "\n" + serviceResponse, e);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Have thrown unexpected exception.\n" + serviceRequest + "\n" + serviceResponse, e);
        }
    }
}

