/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.marshelling;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.marshelling.ContextForJson;
import one.xingyi.core.marshelling.JsonWriter;
import one.xingyi.core.state.StateData;
import one.xingyi.core.utils.Lists;
import one.xingyi.core.utils.Optionals;

class ServiceRequestContextForJson
implements ContextForJson {
    final String protocol;
    final ServiceRequest serviceRequest;

    @Override
    public String protocol() {
        return this.protocol;
    }

    @Override
    public String template(String raw) {
        return raw.replace("{host}", this.serviceRequest.header("host").map(s -> this.protocol + s).orElse(""));
    }

    @Override
    public String acceptHeader() {
        return this.serviceRequest.header("accept").orElse("");
    }

    @Override
    public <J, Entity> J links(JsonWriter<J> jsonWriter, Entity entity, Function<Entity, String> stateFn, Map<String, List<StateData>> stateMap) {
        Object selfLink = jsonWriter.makeObject("_self", this.serviceRequest.uri.toString());
        return (J)Optionals.fold(Optional.ofNullable(stateMap.get(Optional.ofNullable(stateFn.apply(entity)).orElse(""))), () -> jsonWriter.makeList(List.of(selfLink)), list -> jsonWriter.makeList(Lists.insert(selfLink, Lists.map(list, sd -> jsonWriter.makeObject(sd.action, sd.link)))));
    }

    public ServiceRequestContextForJson(String protocol, ServiceRequest serviceRequest) {
        this.protocol = protocol;
        this.serviceRequest = serviceRequest;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceRequestContextForJson)) {
            return false;
        }
        ServiceRequestContextForJson other = (ServiceRequestContextForJson)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$protocol = this.protocol;
        String other$protocol = other.protocol;
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        ServiceRequest this$serviceRequest = this.serviceRequest;
        ServiceRequest other$serviceRequest = other.serviceRequest;
        return !(this$serviceRequest == null ? other$serviceRequest != null : !((Object)this$serviceRequest).equals(other$serviceRequest));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceRequestContextForJson;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $protocol = this.protocol;
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        ServiceRequest $serviceRequest = this.serviceRequest;
        result = result * 59 + ($serviceRequest == null ? 43 : ((Object)$serviceRequest).hashCode());
        return result;
    }

    public String toString() {
        return "ServiceRequestContextForJson(protocol=" + this.protocol + ", serviceRequest=" + this.serviceRequest + ")";
    }
}

