/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.marshelling;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import one.xingyi.core.Cache;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.http.ServiceResponse;
import one.xingyi.core.marshelling.DataToBeSentToClient;
import one.xingyi.core.marshelling.IXingYiResponseSplitter;
import one.xingyi.core.utils.WrappedException;

class XingYiResponseSplitter
implements IXingYiResponseSplitter {
    final Function<ServiceRequest, CompletableFuture<ServiceResponse>> service;
    final Cache<String, CompletableFuture<ServiceResponse>> javascriptCache;

    public XingYiResponseSplitter(Function<ServiceRequest, CompletableFuture<ServiceResponse>> service) {
        this.service = service;
        this.javascriptCache = Cache.dumbCache(url -> (CompletableFuture)service.apply(new ServiceRequest("get", (String)url, List.of(), "")));
    }

    @Override
    public CompletableFuture<DataToBeSentToClient> apply(ServiceResponse serviceResponse) {
        DataToBeSentToClient dataToBeSentToClientLinks = IXingYiResponseSplitter.rawSplit(serviceResponse);
        String urlOrJavascript = dataToBeSentToClientLinks.defn;
        if (urlOrJavascript.startsWith("http") || urlOrJavascript.startsWith("/")) {
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.javascriptCache.apply(urlOrJavascript)).thenApply(sr -> {
                this.checkServiceResponse(serviceResponse, urlOrJavascript, (ServiceResponse)sr);
                return sr.body;
            })).thenApply(javascript -> new DataToBeSentToClient(dataToBeSentToClientLinks.data, (String)javascript))).exceptionally(WrappedException.wrapFnWithE(e -> {
                this.javascriptCache.invalidate(urlOrJavascript);
                throw e;
            }));
        }
        return CompletableFuture.completedFuture(dataToBeSentToClientLinks);
    }

    private void checkServiceResponse(ServiceResponse serviceResponse, String url, ServiceResponse sr) {
        if (sr.statusCode >= 300) {
            this.javascriptCache.invalidate(url);
            throw new RuntimeException("Unexpected response getting defn: " + serviceResponse + "\nOriginal response was" + serviceResponse + "\nJavascript url was " + url + "\nJavascript response" + sr);
        }
    }
}

