/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.optics;

import java.util.function.Function;
import one.xingyi.core.optics.Getter;
import one.xingyi.core.optics.Lens;
import one.xingyi.core.optics.Setter;

class LensImpl<A, B>
implements Lens<A, B> {
    final Getter<A, B> getter;
    final Setter<A, B> setter;

    public LensImpl(Getter<A, B> getter, Setter<A, B> setter) {
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public B get(A a) {
        return this.getter.get(a);
    }

    @Override
    public A set(A a, B b) {
        return this.setter.set(a, b);
    }

    @Override
    public <C> Lens<A, C> andThen(Lens<B, C> lens) {
        Getter<A, C> newGetter = this.getter.andThenGet(lens);
        Setter<Object, Object> newSetter = (a, c) -> this.setter.set(a, lens.set(this.get(a), c));
        return new LensImpl<Object, Object>(newGetter, newSetter);
    }

    @Override
    public A transform(A a, Function<B, B> fn) {
        return this.setter.set(a, fn.apply(this.getter.get(a)));
    }
}

