/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.optics.lensLanguage;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import one.xingyi.core.optics.lensLanguage.DoubleLensDefn;
import one.xingyi.core.optics.lensLanguage.FirstItemInListDefn;
import one.xingyi.core.optics.lensLanguage.IdentityDefn;
import one.xingyi.core.optics.lensLanguage.IntegerLensDefn;
import one.xingyi.core.optics.lensLanguage.ItemAsListDefn;
import one.xingyi.core.optics.lensLanguage.LensDefn;
import one.xingyi.core.optics.lensLanguage.LensValueParser;
import one.xingyi.core.optics.lensLanguage.ListLensDefn;
import one.xingyi.core.optics.lensLanguage.StringLensDefn;
import one.xingyi.core.optics.lensLanguage.ViewLensDefn;
import one.xingyi.core.utils.Lists;
import one.xingyi.core.utils.Strings;

class SimpleLensParser
implements LensValueParser {
    Map<String, Function<String, LensDefn>> primitives = Map.of("integer", name -> new IntegerLensDefn((String)name), "string", name -> new StringLensDefn((String)name), "double", name -> new DoubleLensDefn((String)name));

    SimpleLensParser() {
    }

    @Override
    public List<LensDefn> apply(String s) {
        return Lists.map(Strings.split(s, ","), item -> {
            if (item.equalsIgnoreCase("{firstItem}")) {
                return new FirstItemInListDefn();
            }
            if (item.equalsIgnoreCase("{identity}")) {
                return new IdentityDefn();
            }
            if (item.equalsIgnoreCase("{itemAsList}")) {
                return new ItemAsListDefn();
            }
            List<String> parts = Strings.split(item, "/");
            if (parts.size() != 2) {
                throw new RuntimeException("could not find two parts in item " + item + " which is in " + s);
            }
            String name = parts.get(0);
            String type = parts.get(1);
            Function<String, LensDefn> fn = this.primitives.get(type);
            if (fn == null && type.startsWith("*")) {
                return new ListLensDefn(name, type.substring(1));
            }
            if (fn == null) {
                return new ViewLensDefn(name, type);
            }
            return fn.apply(name);
        });
    }
}

