/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import one.xingyi.core.utils.Lists;
import one.xingyi.core.utils.WrappedException;

public class Reflection<T> {
    final Class<T> clazz;

    public Field field(String fieldName) {
        return WrappedException.wrapCallable(() -> this.clazz.getField(fieldName));
    }

    public Method method0(String methodName, Class<?> ... params) {
        return WrappedException.wrapCallable(() -> this.clazz.getMethod(methodName, params));
    }

    public <A extends Annotation> A classAnnotation(Class<A> a) {
        Annotation result = WrappedException.wrapCallable(() -> this.clazz.getAnnotation(a));
        if (result == null) {
            throw new RuntimeException("could not find " + a + " for class " + this.clazz);
        }
        return (A)result;
    }

    public <A extends Annotation> A methodAnnotation(Class<A> a, String methodName, Class<?> ... params) {
        Annotation result = WrappedException.wrapCallable(() -> this.clazz.getMethod(methodName, new Class[0]).getAnnotation(a));
        if (result == null) {
            throw new RuntimeException("could not find " + a + " for method " + this.clazz + "." + methodName);
        }
        return (A)result;
    }

    public <A extends Annotation> A fieldAnnotation(Class<A> a, String fieldName) {
        Annotation result = WrappedException.wrapCallable(() -> this.clazz.getField(fieldName).getAnnotation(a));
        if (result == null) {
            throw new RuntimeException("could not find " + a + " for field " + this.clazz + "." + fieldName);
        }
        return (A)result;
    }

    public <Returns> List<Method> staticMethodsReturning(Class<Returns> returnClass) {
        return WrappedException.wrapCallable(() -> Lists.filter(Arrays.asList(this.clazz.getMethods()), m -> returnClass.isAssignableFrom(m.getReturnType()) && Modifier.isStatic(m.getModifiers())));
    }

    public List<Method> methodsReturningWithOneParam(String startsWith, Class<?> returnClass) {
        return Lists.filter(Arrays.asList(this.clazz.getMethods()), m -> m.getParameterTypes().length == 1 && m.getName().startsWith(startsWith) && returnClass.isAssignableFrom(m.getReturnType()));
    }

    public Reflection(Class<T> clazz) {
        this.clazz = clazz;
    }
}

