/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.server;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import one.xingyi.core.endpoints.EndPoint;
import one.xingyi.core.http.Header;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.http.ServiceResponse;
import one.xingyi.core.server.HttpUtils;
import one.xingyi.core.server.Streams;
import one.xingyi.core.utils.WrappedException;

public class EndpointHandler
implements HttpHandler {
    final Function<ServiceRequest, CompletableFuture<Optional<ServiceResponse>>> fn;
    private final Function<ServiceRequest, CompletableFuture<ServiceResponse>> kleisli;

    public EndpointHandler(EndPoint fn) {
        this.fn = fn;
        this.kleisli = EndPoint.toKliesli(fn, EndPoint.defaultNotFound(fn));
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        HttpUtils.write(exchange, WrappedException.wrapCallable(() -> this.kleisli.apply(this.makeServiceRequest(exchange)).get()));
    }

    ServiceRequest makeServiceRequest(HttpExchange exchange) throws IOException {
        String method = exchange.getRequestMethod().toLowerCase();
        String body = Streams.readAll(exchange.getRequestBody());
        String uri = exchange.getRequestURI().toString();
        Headers req = exchange.getRequestHeaders();
        ArrayList<Header> headers = new ArrayList<Header>();
        for (Map.Entry<String, List<String>> e : req.entrySet()) {
            for (String v : e.getValue()) {
                headers.add(new Header(e.getKey(), v));
            }
        }
        return new ServiceRequest(method, uri, headers, body);
    }

    public String toString() {
        return "EndpointHandler(fn=" + this.fn + ", kleisli=" + this.kleisli + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EndpointHandler)) {
            return false;
        }
        EndpointHandler other = (EndpointHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Function<ServiceRequest, CompletableFuture<Optional<ServiceResponse>>> this$fn = this.fn;
        Function<ServiceRequest, CompletableFuture<Optional<ServiceResponse>>> other$fn = other.fn;
        if (this$fn == null ? other$fn != null : !this$fn.equals(other$fn)) {
            return false;
        }
        Function<ServiceRequest, CompletableFuture<ServiceResponse>> this$kleisli = this.kleisli;
        Function<ServiceRequest, CompletableFuture<ServiceResponse>> other$kleisli = other.kleisli;
        return !(this$kleisli == null ? other$kleisli != null : !this$kleisli.equals(other$kleisli));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EndpointHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Function<ServiceRequest, CompletableFuture<Optional<ServiceResponse>>> $fn = this.fn;
        result = result * 59 + ($fn == null ? 43 : $fn.hashCode());
        Function<ServiceRequest, CompletableFuture<ServiceResponse>> $kleisli = this.kleisli;
        result = result * 59 + ($kleisli == null ? 43 : $kleisli.hashCode());
        return result;
    }
}

