/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.server;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import one.xingyi.core.http.Header;
import one.xingyi.core.http.ServiceResponse;
import one.xingyi.core.server.Streams;

public class HttpUtils {
    public static ExecutorService makeDefaultExecutor() {
        return Executors.newFixedThreadPool(100, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        });
    }

    public static void write(HttpExchange exchange, ServiceResponse response) throws IOException {
        for (Header h : response.headers) {
            exchange.getResponseHeaders().set(h.name, h.value);
        }
        byte[] bytes = response.body.getBytes("UTF-8");
        exchange.sendResponseHeaders(response.statusCode, bytes.length);
        Streams.sendAll(exchange.getResponseBody(), bytes);
    }
}

