/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.typeDom;

import one.xingyi.core.annotationProcessors.IViewDefnNameToViewName;
import one.xingyi.core.client.IResourceList;
import one.xingyi.core.codeDom.PackageAndClassName;
import one.xingyi.core.embedded.Embedded;
import one.xingyi.core.names.EntityNames;
import one.xingyi.core.names.IServerNames;
import one.xingyi.core.names.ViewNames;
import one.xingyi.core.typeDom.EmbeddedType;
import one.xingyi.core.typeDom.ListType;
import one.xingyi.core.typeDom.PrimitiveType;
import one.xingyi.core.typeDom.ViewType;
import one.xingyi.core.utils.Strings;
import one.xingyi.core.validation.Result;

public interface TypeDom {
    public String fullTypeName();

    default public String forEntity() {
        return this.fullTypeName();
    }

    default public String forView() {
        return this.fullTypeName();
    }

    default public String viewCompanion() {
        return "";
    }

    public TypeDom nested();

    public boolean primitive();

    public String entityNameForLens();

    default public String forToJson(String fieldName, boolean templated) {
        return fieldName;
    }

    public String forFromJson(String var1);

    public String lensDefn(String var1);

    public static Result<String, TypeDom> create(IServerNames names, String rawTypeName, IViewDefnNameToViewName viewNamesMap) {
        String fullTypeName = Strings.removeOptionalFirst("()", rawTypeName);
        PackageAndClassName packageAndClassName = new PackageAndClassName(fullTypeName);
        String listClassName = IResourceList.class.getName();
        String embeddedClassName = Embedded.class.getName();
        if (PackageAndClassName.primitives().contains(packageAndClassName)) {
            return Result.succeed(new PrimitiveType(packageAndClassName));
        }
        if (fullTypeName.startsWith(listClassName)) {
            String nestedName = Strings.extractFromOptionalEnvelope(listClassName + "<", ">", fullTypeName);
            return TypeDom.create(names, nestedName, viewNamesMap).flatMap(nested -> {
                if (viewNamesMap.isDefinedAt(nestedName)) {
                    ViewNames vn = (ViewNames)viewNamesMap.apply(nestedName);
                    EntityNames entityNames = vn.entityNames;
                    return Result.succeed(new ListType(fullTypeName, (TypeDom)nested, entityNames.serverCompanion, entityNames.entityNameForLens));
                }
                return Result.failwith("Could not work out which type " + rawTypeName + "was. Known views are\n" + viewNamesMap.legalValues());
            });
        }
        if (fullTypeName.startsWith(embeddedClassName)) {
            return TypeDom.create(names, Strings.extractFromOptionalEnvelope(embeddedClassName + "<", ">", fullTypeName), viewNamesMap).map(nested -> new EmbeddedType(fullTypeName, (TypeDom)nested));
        }
        if (fullTypeName.indexOf("<") == -1 && viewNamesMap.isDefinedAt(fullTypeName)) {
            ViewNames vn = (ViewNames)viewNamesMap.apply(fullTypeName);
            EntityNames tr = vn.entityNames;
            String serviceInterface = tr.serverInterface.asString();
            return Result.succeed(new ViewType(fullTypeName, serviceInterface, vn.clientView.asString(), vn.clientCompanion.asString(), tr.serverCompanion.asString(), tr.entityNameForLens));
        }
        return Result.failwith("Could not work out what type " + rawTypeName + " was. Known views are\n" + viewNamesMap.legalValues());
    }
}

