/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.concurrent.Callable;
import one.xingyi.core.utils.WrappedException;

public class Files {
    public static void setText(Callable<PrintWriter> writer, String text) {
        WrappedException.wrap(() -> {
            try (PrintWriter printWriter = (PrintWriter)writer.call();){
                printWriter.print(text);
                printWriter.flush();
            }
        });
    }

    public static String getText(String name) {
        return WrappedException.wrapCallable(() -> {
            StringBuilder result = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.class.getClassLoader().getResourceAsStream(name)));){
                String line;
                while ((line = reader.readLine()) != null) {
                    result.append(line).append("\n");
                }
            }
            return result.toString();
        });
    }

    public static String getText(File file) {
        return WrappedException.wrapCallable(() -> {
            StringBuilder result = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = reader.readLine()) != null) {
                    result.append(line).append("\n");
                }
            }
            return result.toString();
        });
    }
}

