/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public class MapUtils {
    @SafeVarargs
    public static <K, V> Map<K, V> append(Map<K, V> ... maps) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map<K, V> map : maps) {
            result.putAll(map);
        }
        return result;
    }

    public static <K, V> Map<K, V> appendKeepingOrder(List<Map<K, V>> maps) {
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
        for (Map<K, V> map : maps) {
            result.putAll(map);
        }
        return result;
    }

    public static <K, V> void add(Map<K, List<V>> map, K k, V v) {
        List<V> list = map.get(k);
        if (list == null) {
            list = new ArrayList<V>();
            map.put(k, list);
        }
        list.add(v);
    }

    public static <K, V> void addNotAllowingDuplicates(HashMap<K, V> map, K k, V v, BiFunction<K, V, String> error) {
        if (map.containsKey(k)) {
            throw new IllegalArgumentException(error.apply(k, map.get(k)));
        }
        map.put(k, v);
    }
}

