/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.utils;

import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import one.xingyi.core.utils.ChainPartialBiFunction;
import one.xingyi.core.utils.SimplePartialBiFunction;

public interface PartialBiFunction<From1, From2, To>
extends BiFunction<From1, From2, To> {
    public boolean isDefinedAt(From1 var1, From2 var2);

    default public To orDefault(From1 from1, From2 from2, Supplier<To> defSupplier) {
        if (this.isDefinedAt(from1, from2)) {
            return (To)this.apply(from1, from2);
        }
        return defSupplier.get();
    }

    public static <From1, From2, To> PartialBiFunction<From1, From2, To> pf(BiFunction<From1, From2, Boolean> acceptor, BiFunction<From1, From2, To> fn) {
        return new SimplePartialBiFunction<From1, From2, To>(acceptor, fn);
    }

    @SafeVarargs
    public static <From1, From2, To> PartialBiFunction<From1, From2, To> chain(PartialBiFunction<From1, From2, To> ... pfs) {
        return new ChainPartialBiFunction<From1, From2, To>(Arrays.asList(pfs));
    }
}

