/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.validation;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import one.xingyi.core.utils.Function3;
import one.xingyi.core.utils.FunctionWithException;
import one.xingyi.core.utils.Lists;
import one.xingyi.core.utils.Optionals;
import one.xingyi.core.validation.Failures;
import one.xingyi.core.validation.Succeeds;

public interface Result<Fail, T> {
    public List<Fail> fails();

    public Optional<T> result();

    public Result<Fail, T> forEach(Consumer<T> var1);

    public <T1> Result<Fail, T1> map(Function<T, T1> var1);

    public <T1> Result<Fail, T1> flatMap(Function<T, Result<Fail, T1>> var1);

    public <Fail1> Result<Fail1, T> failMap(FunctionWithException<Fail, Fail1> var1);

    public static <Fail, T1, T2, T> Result<Fail, T> join(Result<Fail, T1> res1, Result<Fail, T2> res2, BiFunction<T1, T2, T> fn) {
        return res1.flatMap(r1 -> res2.map(r2 -> fn.apply(r1, r2)));
    }

    public static <Fail, T1, T2, T3, T> Result<Fail, T> join(Result<Fail, T1> res1, Result<Fail, T2> res2, Result<Fail, T3> res3, Function3<T1, T2, T3, T> fn) {
        return res1.flatMap(r1 -> res2.flatMap(r2 -> res3.map(r3 -> fn.apply(r1, r2, r3))));
    }

    public static <Fail, T> Result<Fail, T> from(Optional<T> optT, Supplier<Fail> supplier) {
        return Optionals.fold(optT, () -> Result.failwith(supplier.get()), Result::succeed);
    }

    public static <Fail, T> Result<Fail, List<T>> merge(List<Result<Fail, T>> results) {
        return Result.apply(Lists.flatMap(results, f -> f.fails()), Lists.flatMapOptional(results, Result::result));
    }

    @SafeVarargs
    public static <Fail, T> Result<Fail, T> validate(T t, Function<T, List<Fail>> ... failFns) {
        return Result.apply(Lists.flatMap(Arrays.asList(failFns), fn -> (List)fn.apply(t)), t);
    }

    public static <Fail, T> Result<Fail, T> succeed(T t) {
        return new Succeeds(t);
    }

    public static <Fail, T> Result<Fail, T> failwith(Fail fail) {
        return new Failures(List.of(fail));
    }

    @SafeVarargs
    public static <Fail, T> Result<Fail, T> allFail(Fail ... fails) {
        return new Failures(Arrays.asList(fails));
    }

    public static <Fail, T> Result<Fail, T> apply(List<Fail> fails, T t) {
        return fails.isEmpty() ? new Succeeds(t) : new Failures(fails);
    }

    public static <Fail, T> List<T> successes(List<Result<Fail, T>> results) {
        return Lists.flatMapOptional(results, Result::result);
    }

    public static <Fail, T> List<Fail> failures(List<Result<Fail, T>> results) {
        return Lists.flatMap(results, Result::fails);
    }
}

