/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.endpoints;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import one.xingyi.core.endpoints.ResourceWithFromEndpointAcceptor;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.utils.FunctionFixture;
import org.junit.Assert;
import org.junit.Test;

public class ResourceWithFromEndpointAcceptorTest
implements FunctionFixture {
    ResourceWithFromEndpointAcceptor<String> acceptor = new ResourceWithFromEndpointAcceptor("someMethod", "/somePath/{id}", (sr, s) -> sr.uri + ":" + s, "test");

    @Test
    public void testAccessors() {
        Assert.assertEquals((Object)"someMethod", (Object)this.acceptor.method());
        Assert.assertEquals((Object)"/somePath/{id}", (Object)this.acceptor.templatedPath());
    }

    @Test
    public void testApply() {
        Assert.assertEquals(Optional.empty(), (Object)this.acceptor.apply(ServiceRequest.sr((String)"wrongMethod", (String)"/somePath/1")));
        Assert.assertEquals(Optional.empty(), (Object)this.acceptor.apply(ServiceRequest.sr((String)"someMethod", (String)"/someWrongPath/1")));
        Assert.assertEquals(Optional.empty(), (Object)this.acceptor.apply(ServiceRequest.sr((String)"someMethod", (String)"/somePath/1/WithStuffOnEnd")));
        Assert.assertEquals(Optional.of("/somePath/someId:someId"), (Object)this.acceptor.apply(ServiceRequest.sr((String)"someMethod", (String)"/somePath/someId")));
    }

    @Test
    public void testAndIfMatches() throws ExecutionException, InterruptedException {
        Assert.assertEquals(Optional.of("123"), ((CompletableFuture)this.acceptor.andIfMatches(this.kleisli("/somePath/someId:someId", "123")).apply(ServiceRequest.sr((String)"someMethod", (String)"/somePath/someId"))).get());
    }
}

