/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.names;

import java.util.Optional;
import one.xingyi.core.codeDom.PackageAndClassName;
import one.xingyi.core.endpoints.BookmarkCodeAndUrlPattern;
import one.xingyi.core.names.EntityNames;
import one.xingyi.core.names.IClassNameStrategy;
import one.xingyi.core.names.IPackageNameStrategy;
import one.xingyi.core.names.IServerNames;
import one.xingyi.core.names.ViewNames;
import one.xingyi.core.validation.Result;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SimpleServerNamesTest {
    IPackageNameStrategy packageNameStrategy = IPackageNameStrategy.simple;
    IClassNameStrategy classNameStrategy = IClassNameStrategy.simple;
    IServerNames serverNames = IServerNames.simple((IPackageNameStrategy)this.packageNameStrategy, (IClassNameStrategy)this.classNameStrategy);

    @Test
    public void testEntityNameWhenClassStartsWithIAndEndInDefn() {
        EntityNames actual = this.serverNames.entityName("original.package.IEntityDefn");
        Assert.assertEquals((Object)new PackageAndClassName("original.package.IEntityDefn"), (Object)actual.originalDefn);
        Assert.assertEquals((Object)new PackageAndClassName("original.package.server.domain.IEntity"), (Object)actual.serverInterface);
        Assert.assertEquals((Object)new PackageAndClassName("original.package.server.domain.Entity"), (Object)actual.serverEntity);
        Assert.assertEquals((Object)new PackageAndClassName("original.package.server.companion.EntityCompanion"), (Object)actual.serverCompanion);
        Assert.assertEquals((Object)new PackageAndClassName("original.package.server.controller.IEntityController"), (Object)actual.serverController);
        Assert.assertEquals((Object)new PackageAndClassName("original.package.client.entitydefn.IEntityClientEntity"), (Object)actual.clientResource);
        Assert.assertEquals((Object)new PackageAndClassName("original.package.client.resourcecompanion.EntityCompositeCompanion"), (Object)actual.clientResourceCompanion);
        Assert.assertEquals((Object)"Entity", (Object)actual.entityNameForLens);
    }

    @Test
    public void testViewName() {
        ViewNames actual = this.serverNames.viewName("original.package.IViewRootDefn", " a.b.c.IEntityDefn");
        Assert.assertEquals((Object)new PackageAndClassName("original.package.IViewRootDefn"), (Object)actual.originalDefn);
        Assert.assertEquals((Object)new PackageAndClassName("original.package.client.view.ViewRoot"), (Object)actual.clientView);
    }

    @Test
    public void testLensName() {
        EntityNames entityNames = new EntityNames(new PackageAndClassName("p.ISomeDefn"), null, null, null, null, null, null, "someEntityForLens");
        Assert.assertEquals((Object)"lens_someEntityForLens_fieldName", (Object)this.serverNames.entityLensName(entityNames, "fieldName", ""));
        Assert.assertEquals((Object)"override", (Object)this.serverNames.entityLensName(entityNames, "fieldName", "override"));
    }

    @Test
    public void testLensPath() {
        EntityNames entityNames = (EntityNames)Mockito.mock(EntityNames.class);
        Assert.assertEquals((Object)Result.succeed((Object)"fieldName"), (Object)this.serverNames.entityLensPath(entityNames, "fieldName", ""));
        Assert.assertEquals((Object)Result.succeed((Object)"name1"), (Object)this.serverNames.entityLensPath(entityNames, "fieldName", "name1"));
    }

    @Test
    public void testBookmark() {
        EntityNames entityNames = (EntityNames)Mockito.mock(EntityNames.class);
        Assert.assertEquals(Optional.empty(), (Object)this.serverNames.bookmarkAndUrl(entityNames, "", "", ""));
        Assert.assertEquals(Optional.empty(), (Object)this.serverNames.bookmarkAndUrl(entityNames, "just bookmark", "", ""));
        Assert.assertEquals(Optional.empty(), (Object)this.serverNames.bookmarkAndUrl(entityNames, "", "justget", ""));
        Assert.assertEquals(Optional.of(new BookmarkCodeAndUrlPattern("overrideB", "overrideU", "{host}overrideB/code")), (Object)this.serverNames.bookmarkAndUrl(entityNames, "overrideB", "overrideU", ""));
        Assert.assertEquals(Optional.of(new BookmarkCodeAndUrlPattern("overrideB", "overrideU", "overrideC")), (Object)this.serverNames.bookmarkAndUrl(entityNames, "overrideB", "overrideU", "overrideC"));
    }
}

