/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.typeDom;

import one.xingyi.core.annotationProcessors.IViewDefnNameToViewName;
import one.xingyi.core.annotationProcessors.ViewDefnNameToViewNamesFixture;
import one.xingyi.core.client.IResourceList;
import one.xingyi.core.codeDom.PackageAndClassName;
import one.xingyi.core.embedded.Embedded;
import one.xingyi.core.names.IClassNameStrategy;
import one.xingyi.core.names.IPackageNameStrategy;
import one.xingyi.core.names.IServerNames;
import one.xingyi.core.typeDom.BooleanPrimitiveType;
import one.xingyi.core.typeDom.DoublePrimitiveType;
import one.xingyi.core.typeDom.EmbeddedType;
import one.xingyi.core.typeDom.IntegerPrimitiveType;
import one.xingyi.core.typeDom.PrimitiveType;
import one.xingyi.core.typeDom.StringPrimitiveType;
import one.xingyi.core.typeDom.TypeDom;
import one.xingyi.core.typeDom.ViewType;
import one.xingyi.core.utils.Strings;
import one.xingyi.core.validation.Result;
import org.junit.Assert;
import org.junit.Test;

public class TypeDomTest
implements ViewDefnNameToViewNamesFixture {
    IServerNames names = IServerNames.simple((IPackageNameStrategy)IPackageNameStrategy.simple, (IClassNameStrategy)IClassNameStrategy.simple);
    PackageAndClassName stringPn = this.pn(String.class.getName());
    PrimitiveType stringPt = new StringPrimitiveType();
    PackageAndClassName embeddedStringPn = this.pn(Strings.lift((String)Embedded.class.getName(), (String)String.class.getName()));
    EmbeddedType embeededStringPt = new EmbeddedType(this.embeddedStringPn.asString(), (TypeDom)this.stringPt);
    PackageAndClassName intPn = this.pn(Integer.class.getName());
    PackageAndClassName listIntPn = this.pn(Strings.lift((String)IResourceList.class.getName(), (String)Integer.class.getName()));
    PrimitiveType intPt = new IntegerPrimitiveType();
    PackageAndClassName embeddedIntPn = this.pn(Strings.lift((String)Embedded.class.getName(), (String)Integer.class.getName()));
    EmbeddedType embeededIntPt = new EmbeddedType(this.embeddedIntPn.asString(), (TypeDom)this.intPt);
    PackageAndClassName doublePn = this.pn(Double.class.getName());
    PackageAndClassName listDoublePn = this.pn(Strings.lift((String)IResourceList.class.getName(), (String)Double.class.getName()));
    PrimitiveType doublePt = new DoublePrimitiveType();
    PackageAndClassName booleanPn = this.pn(Boolean.class.getName());
    PackageAndClassName listBooleanPn = this.pn(Strings.lift((String)IResourceList.class.getName(), (String)Boolean.class.getName()));
    PrimitiveType booleanPt = new BooleanPrimitiveType();

    PackageAndClassName pn(String s) {
        return new PackageAndClassName(s);
    }

    @Test
    public void testPrimitives() {
        Assert.assertEquals((Object)Result.succeed((Object)this.stringPt), (Object)TypeDom.create((IServerNames)this.names, (String)("()" + this.stringPn.asString()), (IViewDefnNameToViewName)viewToViewNames));
        Assert.assertEquals((Object)Result.succeed((Object)this.intPt), (Object)TypeDom.create((IServerNames)this.names, (String)("()" + this.intPn.asString()), (IViewDefnNameToViewName)viewToViewNames));
        Assert.assertEquals((Object)Result.succeed((Object)this.doublePt), (Object)TypeDom.create((IServerNames)this.names, (String)("()" + this.doublePn.asString()), (IViewDefnNameToViewName)viewToViewNames));
        Assert.assertEquals((Object)Result.succeed((Object)this.booleanPt), (Object)TypeDom.create((IServerNames)this.names, (String)("()" + this.booleanPn.asString()), (IViewDefnNameToViewName)viewToViewNames));
    }

    @Test
    public void testEmbedded() {
        Assert.assertEquals((Object)Result.succeed((Object)this.embeededStringPt), (Object)TypeDom.create((IServerNames)this.names, (String)("()" + this.embeddedStringPn.asString()), (IViewDefnNameToViewName)viewToViewNames));
        Assert.assertEquals((Object)Result.succeed((Object)this.embeededIntPt), (Object)TypeDom.create((IServerNames)this.names, (String)("()" + this.embeddedIntPn.asString()), (IViewDefnNameToViewName)viewToViewNames));
    }

    @Test
    public void testView() {
        Result actual = TypeDom.create((IServerNames)this.names, (String)"a.b.IPersonViewDefn", (IViewDefnNameToViewName)viewToViewNames);
        Assert.assertEquals((Object)Result.succeed((Object)new ViewType("a.b.IPersonViewDefn", "a.b.server.domain.IPerson", "a.b.client.view.PersonView", "a.b.client.viewcompanion.PersonViewCompanion", "a.b.server.companion.PersonCompanion", "Person")), (Object)actual);
    }

    @Test
    public void testAnythingInsideBracketsDoesntWork() {
        Assert.assertEquals((Object)Result.failwith((Object)"Could not work out what type Thing<something> was. Known views are\nIOneViewDefn\nIPersonViewDefn\nITwoViewDefn"), (Object)TypeDom.create((IServerNames)this.names, (String)"Thing<something>", (IViewDefnNameToViewName)viewToViewNames));
    }

    @Test
    public void testTransformed() {
        Assert.assertEquals((Object)"java.lang.String", (Object)this.stringPt.forEntity());
        Result result = TypeDom.create((IServerNames)this.names, (String)"a.b.IPersonViewDefn", (IViewDefnNameToViewName)viewToViewNames);
        TypeDom viewType = (TypeDom)result.result().get();
        Assert.assertEquals((String)result.toString(), (Object)"a.b.server.domain.IPerson", (Object)viewType.forEntity());
        Assert.assertEquals((String)result.toString(), (Object)"a.b.client.view.PersonView", (Object)viewType.forView());
        Result result1 = TypeDom.create((IServerNames)this.names, (String)"one.xingyi.core.client.IResourceList<a.b.IPersonViewDefn>", (IViewDefnNameToViewName)viewToViewNames);
        System.out.println(result1);
        TypeDom listType = (TypeDom)result1.result().get();
        Assert.assertEquals((Object)"one.xingyi.core.client.IResourceList<a.b.server.domain.IPerson>", (Object)listType.forEntity());
        Assert.assertEquals((Object)"one.xingyi.core.client.IResourceList<a.b.client.view.PersonView>", (Object)listType.forView());
    }

    @Test
    public void testCanBeAssignedToForPrimitives() {
        Assert.assertTrue((boolean)this.intPt.isAssignableFrom((TypeDom)this.intPt));
        Assert.assertFalse((boolean)this.intPt.isAssignableFrom((TypeDom)this.doublePt));
        Assert.assertTrue((boolean)this.doublePt.isAssignableFrom((TypeDom)this.doublePt));
        Assert.assertFalse((boolean)this.doublePt.isAssignableFrom((TypeDom)this.intPt));
        Assert.assertTrue((boolean)this.stringPt.isAssignableFrom((TypeDom)this.stringPt));
        Result result = TypeDom.create((IServerNames)this.names, (String)"a.b.IPersonViewDefn", (IViewDefnNameToViewName)viewToViewNames);
        TypeDom viewType = (TypeDom)result.result().get();
        Assert.assertFalse((boolean)this.stringPt.isAssignableFrom(viewType));
    }
}

