/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.acceptHeader;

import java.util.Arrays;
import java.util.List;
import one.xingyi.core.acceptHeader.AcceptHeaderDetails;
import one.xingyi.core.acceptHeader.AcceptHeaderParser;
import one.xingyi.core.utils.Lists;

class SimpleAcceptHeaderParser
implements AcceptHeaderParser {
    SimpleAcceptHeaderParser() {
    }

    @Override
    public AcceptHeaderDetails apply(String header) {
        List<String> parts = Lists.filter(Arrays.asList(header.split("\\.")), part -> part.length() > 0);
        if (parts.size() < 2) {
            return AcceptHeaderDetails.invalid();
        }
        if (!parts.get(0).equalsIgnoreCase("application/xingyi") || !parts.get(1).equalsIgnoreCase("parserAndWriter")) {
            return AcceptHeaderDetails.invalid();
        }
        List<String> lensNames = Lists.map(parts.subList(2, parts.size()), s -> this.trimName(header, (String)s));
        return AcceptHeaderDetails.valid(lensNames);
    }

    private String trimName(String header, String s) {
        if (s.startsWith("lens_")) {
            return s.substring(5);
        }
        throw new RuntimeException("Lens name '" + s + " should start with 'lens_' the header was " + header);
    }
}

