/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.annotationProcessors;

import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Element;
import one.xingyi.core.annotationProcessors.ElementFail;
import one.xingyi.core.annotationProcessors.IElementToFieldDom;
import one.xingyi.core.annotationProcessors.IViewDefnNameToViewName;
import one.xingyi.core.annotations.Field;
import one.xingyi.core.codeDom.FieldDom;
import one.xingyi.core.codeDom.ResourceDom;
import one.xingyi.core.names.IServerNames;
import one.xingyi.core.typeDom.TypeDom;
import one.xingyi.core.utils.Lists;
import one.xingyi.core.utils.LoggerAdapter;
import one.xingyi.core.utils.Strings;
import one.xingyi.core.validation.Result;

abstract class AbstractElementToFieldDom
implements IElementToFieldDom {
    final LoggerAdapter loggerAdapter;
    final IServerNames serverNames;

    abstract String findLensName(String var1, String var2);

    abstract Result<String, String> findLensPath(String var1, String var2);

    private List<String> validateViewField(Optional<ResourceDom> optResourceDom, FieldDom viewField) {
        if (optResourceDom.isEmpty()) {
            return List.of();
        }
        ResourceDom resourceDom = optResourceDom.get();
        Optional<FieldDom> optResourceField = Lists.find(resourceDom.fields.allFields, resourceField -> resourceField.name.equals(viewField.name));
        if (optResourceField.isEmpty()) {
            return List.of("Cannot find matching field in " + resourceDom.entityNames.originalDefn.asString() + " for " + viewField.name);
        }
        FieldDom resourceField2 = optResourceField.get();
        if (!resourceField2.typeDom.isAssignableFrom(viewField.typeDom)) {
            return List.of("Field " + viewField.name + " has type " + viewField.typeDom.fullTypeName() + " but in resource " + resourceDom.entityNames.originalDefn.asString() + " has type " + resourceField2.typeDom.fullTypeName());
        }
        return List.of();
    }

    @Override
    public Result<ElementFail, FieldDom> apply(Element element, IViewDefnNameToViewName viewNamesMap, Optional<ResourceDom> resourceDoms) {
        String fieldType = element.asType().toString();
        String fieldName = element.getSimpleName().toString();
        Result<String, TypeDom> typeDom = TypeDom.create(this.serverNames, fieldType, viewNamesMap);
        this.loggerAdapter.info("creating " + fieldName + " " + resourceDoms.isPresent());
        return ElementFail.lift(element, typeDom.flatMap(td -> {
            Field annotation = element.getAnnotation(Field.class);
            String lensName = this.findLensName(fieldName, Optional.ofNullable(annotation).map(Field::lensName).orElse(""));
            String rawLensPath = Optional.ofNullable(annotation).map(Field::lensPath).orElse("");
            this.loggerAdapter.info("rawlenspath  " + rawLensPath + " " + resourceDoms.isPresent());
            return this.findLensPath(td.lensDefn(fieldName), rawLensPath).flatMap(lensPath -> {
                this.loggerAdapter.info("madelenspath  " + lensPath + " " + resourceDoms.isPresent());
                Boolean readOnly = Optional.ofNullable(annotation).map(Field::readOnly).orElse(false);
                String javascriptBody = Strings.from(Optional.ofNullable(annotation).map(Field::javascript).orElse(""), "return lens('" + fieldName + "');");
                String javascript = "function " + lensName + "(){" + javascriptBody + "};";
                Boolean templated = Optional.ofNullable(annotation).map(a -> a.templated()).orElse(false);
                Boolean deprecated = element.getAnnotation(Deprecated.class) != null;
                FieldDom fieldDom = new FieldDom((TypeDom)td, fieldName, readOnly, lensName, (String)lensPath, javascript, templated, deprecated);
                this.loggerAdapter.info("made fieldDom  " + fieldDom + " " + resourceDoms.isPresent());
                List<String> errors = this.validateViewField(resourceDoms, fieldDom);
                this.loggerAdapter.info("made errors for " + fieldName + " " + errors);
                if (errors.size() > 0) {
                    return Result.failwith(errors.toString());
                }
                return Result.succeed(fieldDom);
            });
        }));
    }

    public AbstractElementToFieldDom(LoggerAdapter loggerAdapter, IServerNames serverNames) {
        this.loggerAdapter = loggerAdapter;
        this.serverNames = serverNames;
    }
}

