/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.annotationProcessors;

import java.util.Optional;
import javax.lang.model.element.Element;
import one.xingyi.core.utils.LoggerAdapter;
import one.xingyi.core.utils.Optionals;
import one.xingyi.core.validation.Result;

public class ElementFail {
    public final String message;
    public final Optional<Element> optElement;

    public ElementFail(String message, Element element) {
        this.message = message;
        this.optElement = Optional.of(element);
    }

    public void logMe(LoggerAdapter log) {
        Optionals.doit(this.optElement, () -> log.error(this.message), e -> log.error((Element)e, this.message));
    }

    public static <T> Result<ElementFail, T> lift(Element element, Result<String, T> result) {
        return result.failMap(s -> new ElementFail((String)s, element));
    }

    public String toString() {
        return "ElementFail(message=" + this.message + ", optElement=" + this.optElement + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElementFail)) {
            return false;
        }
        ElementFail other = (ElementFail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$message = this.message;
        String other$message = other.message;
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Optional<Element> this$optElement = this.optElement;
        Optional<Element> other$optElement = other.optElement;
        return !(this$optElement == null ? other$optElement != null : !((Object)this$optElement).equals(other$optElement));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElementFail;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $message = this.message;
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Optional<Element> $optElement = this.optElement;
        result = result * 59 + ($optElement == null ? 43 : ((Object)$optElement).hashCode());
        return result;
    }
}

