/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.annotationProcessors;

import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import one.xingyi.core.codeDom.PackageAndClassName;
import one.xingyi.core.utils.Files;
import one.xingyi.core.utils.LoggerAdapter;
import one.xingyi.core.utils.WrappedException;

abstract class ProcessAnnotations<T extends Annotation> {
    final Class<T> annotationClass;
    final RoundEnvironment env;
    final Messager messager;
    final Filer filer;

    abstract void doit(LoggerAdapter var1, TypeElement var2, T var3);

    boolean validateElements(LoggerAdapter log, Set<? extends Element> elements) {
        return true;
    }

    public void process() {
        Set<? extends Element> elements = this.env.getElementsAnnotatedWith(this.annotationClass);
        if (this.validateElements(LoggerAdapter.fromMessager(this.messager), elements)) {
            for (Element element : elements) {
                if (element.getKind() != ElementKind.INTERFACE) continue;
                LoggerAdapter log = LoggerAdapter.fromMessager(this.messager, element);
                T annotation = element.getAnnotation(this.annotationClass);
                this.doit(log, (TypeElement)element, annotation);
            }
        }
    }

    void makeClassFile(PackageAndClassName packageAndClassName, String classString, Element element) {
        WrappedException.wrap(() -> {
            JavaFileObject builderFile = this.filer.createSourceFile(packageAndClassName.asString(), new Element[0]);
            Files.setText(() -> new PrintWriter(builderFile.openWriter()), classString);
        });
    }

    public ProcessAnnotations(Class<T> annotationClass, RoundEnvironment env, Messager messager, Filer filer) {
        this.annotationClass = annotationClass;
        this.env = env;
        this.messager = messager;
        this.filer = filer;
    }
}

