/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.annotationProcessors;

import java.util.List;
import java.util.Optional;
import javax.lang.model.element.TypeElement;
import one.xingyi.core.annotationProcessors.ActionsDom;
import one.xingyi.core.annotationProcessors.CreateDom;
import one.xingyi.core.annotationProcessors.CreateWithoutIdDom;
import one.xingyi.core.annotationProcessors.DeleteDom;
import one.xingyi.core.annotationProcessors.ElementFail;
import one.xingyi.core.annotationProcessors.GetDom;
import one.xingyi.core.annotationProcessors.IElementToEntityDom;
import one.xingyi.core.annotationProcessors.IElementToFieldListDom;
import one.xingyi.core.annotationProcessors.IViewDefnNameToViewName;
import one.xingyi.core.annotationProcessors.OptionalGetDom;
import one.xingyi.core.annotationProcessors.PostDom;
import one.xingyi.core.annotationProcessors.PrototypeDom;
import one.xingyi.core.annotationProcessors.PrototypeNoIdDom;
import one.xingyi.core.annotationProcessors.PutDom;
import one.xingyi.core.annotations.Create;
import one.xingyi.core.annotations.CreateWithoutId;
import one.xingyi.core.annotations.Delete;
import one.xingyi.core.annotations.Get;
import one.xingyi.core.annotations.OptionalGet;
import one.xingyi.core.annotations.Post;
import one.xingyi.core.annotations.Prototype;
import one.xingyi.core.annotations.PrototypeNoId;
import one.xingyi.core.annotations.Put;
import one.xingyi.core.annotations.Resource;
import one.xingyi.core.codeDom.FieldListDom;
import one.xingyi.core.codeDom.ResourceDom;
import one.xingyi.core.endpoints.BookmarkCodeAndUrlPattern;
import one.xingyi.core.names.EntityNames;
import one.xingyi.core.names.IServerNames;
import one.xingyi.core.utils.Lists;
import one.xingyi.core.validation.Result;

class SimpleElementToEntityDom
implements IElementToEntityDom {
    final IServerNames serverNames;
    final EntityNames entityNames;
    final IElementToFieldListDom elementToFieldListDom;

    @Override
    public Result<ElementFail, ResourceDom> apply(TypeElement element, IViewDefnNameToViewName viewNamesMap) {
        Resource annotation = element.getAnnotation(Resource.class);
        String bookmark = annotation.bookmark();
        String rootUrl = annotation.rootUrl();
        String urlWithId = annotation.urlWithId();
        Optional<BookmarkCodeAndUrlPattern> bookmarkAndUrlPattern = this.serverNames.bookmarkAndUrl(this.entityNames, bookmark, urlWithId, annotation.codeUrl());
        List<PostDom> pathDoms = Lists.collect(element.getEnclosedElements(), e -> e.getAnnotation(Post.class) != null, e -> PostDom.create(e.getSimpleName().toString(), e.getAnnotation(Post.class), urlWithId));
        ActionsDom actionsDom = new ActionsDom(Optional.ofNullable(element.getAnnotation(Get.class)).map(get -> new GetDom()), Optional.ofNullable(element.getAnnotation(OptionalGet.class)).map(get -> new OptionalGetDom()), Optional.ofNullable(element.getAnnotation(Put.class)).map(put -> new PutDom()), Optional.ofNullable(element.getAnnotation(Delete.class)).map(delete -> new DeleteDom()), Optional.ofNullable(element.getAnnotation(Create.class)).map(crate -> new CreateDom()), Optional.ofNullable(element.getAnnotation(CreateWithoutId.class)).map(create -> new CreateWithoutIdDom(rootUrl)), Optional.ofNullable(element.getAnnotation(Prototype.class)).map(prototype -> new PrototypeDom(prototype.value())), Optional.ofNullable(element.getAnnotation(PrototypeNoId.class)).map(dom -> new PrototypeNoIdDom(dom.prototypeId(), rootUrl)), pathDoms);
        return ((Result)this.elementToFieldListDom.apply(element, viewNamesMap, Optional.empty())).map(fieldListDom -> new ResourceDom(element.getAnnotation(Deprecated.class) != null, this.entityNames, bookmarkAndUrlPattern, (FieldListDom)fieldListDom, actionsDom));
    }

    public SimpleElementToEntityDom(IServerNames serverNames, EntityNames entityNames, IElementToFieldListDom elementToFieldListDom) {
        this.serverNames = serverNames;
        this.entityNames = entityNames;
        this.elementToFieldListDom = elementToFieldListDom;
    }
}

