/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.annotationProcessors;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;
import one.xingyi.core.annotationProcessors.ElementFail;
import one.xingyi.core.annotations.CombinedView;
import one.xingyi.core.codeDom.CompositeViewDom;
import one.xingyi.core.filemaker.CompositeViewCompanionMaker;
import one.xingyi.core.filemaker.CompositeViewImplMaker;
import one.xingyi.core.filemaker.CompositeViewInterfaceMaker;
import one.xingyi.core.filemaker.FileDefn;
import one.xingyi.core.filemaker.IFileMaker;
import one.xingyi.core.names.IClassNameStrategy;
import one.xingyi.core.names.IPackageNameStrategy;
import one.xingyi.core.utils.Files;
import one.xingyi.core.utils.LoggerAdapter;
import one.xingyi.core.utils.Strings;
import one.xingyi.core.utils.WrappedException;
import one.xingyi.core.validation.Result;

public class XingYiClientAnnotationProcessor
extends AbstractProcessor {
    private Types typeUtils;
    private Elements elementUtils;
    private Filer filer;
    private Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
        processingEnv.getOptions();
    }

    static <T extends Element> Comparator<T> comparator() {
        return (a, b) -> a.asType().toString().compareTo(b.asType().toString());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annoations, RoundEnvironment env) {
        IPackageNameStrategy packageNameStrategy = IPackageNameStrategy.simple;
        IClassNameStrategy classNameStrategy = IClassNameStrategy.simple;
        LoggerAdapter log = LoggerAdapter.fromMessager(this.messager);
        log.info("Processing XingYi Client Annotations");
        try {
            ArrayList<? extends Element> elements = new ArrayList<Element>(env.getElementsAnnotatedWith(CombinedView.class));
            for (Element element : elements) {
                Result<ElementFail, CompositeViewDom> resultDom = CompositeViewDom.create(log, (TypeElement)element, packageNameStrategy, classNameStrategy);
                for (ElementFail fail : resultDom.fails()) {
                    fail.logMe(log);
                }
                resultDom.forEach(dom -> {
                    for (IFileMaker iFileMaker : List.of(new CompositeViewInterfaceMaker(), new CompositeViewImplMaker(), new CompositeViewCompanionMaker())) {
                        Result<String, FileDefn> makeFileResult = iFileMaker.apply(dom);
                        makeFileResult.forEach(defn -> this.makeClassFile((FileDefn)defn));
                        if (makeFileResult.fails().size() <= 0) continue;
                        log.error(element, makeFileResult.fails().toString());
                    }
                });
            }
        }
        catch (Exception e) {
            Throwable unwrapped = WrappedException.unWrap(e);
            log.error("In Client Annotation Processor\n" + Strings.getFrom(unwrapped::printStackTrace));
        }
        return false;
    }

    void makeClassFile(FileDefn fileDefn) {
        WrappedException.wrap(() -> {
            JavaFileObject builderFile = this.filer.createSourceFile(fileDefn.packageAndClassName.asString(), new Element[0]);
            Files.setText(() -> new PrintWriter(builderFile.openWriter()), fileDefn.content);
        });
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(CombinedView.class.getName());
    }
}

