/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import one.xingyi.core.client.SimpleList;

public interface ISimpleList<T>
extends Iterable<T> {
    public static final ISimpleList<Object> empty = ISimpleList.fromList(List.of());

    public static <T> ISimpleList<T> empty() {
        return empty;
    }

    public int size();

    public T get(int var1);

    public ISimpleList<T> withItem(int var1, T var2);

    public ISimpleList<T> append(T var1);

    default public List<T> toList() {
        ArrayList result = new ArrayList();
        for (Object t : this) {
            result.add(t);
        }
        return result;
    }

    @SafeVarargs
    public static <T> ISimpleList<T> create(T ... ts) {
        return new SimpleList<T>(Arrays.asList(ts));
    }

    public static <T> ISimpleList<T> fromList(List<T> ts) {
        return new SimpleList<T>(ts);
    }
}

