/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.codeDom;

import javax.lang.model.element.Element;
import one.xingyi.core.annotationProcessors.ElementFail;
import one.xingyi.core.codeDom.CodeDom;
import one.xingyi.core.codeDom.PackageAndClassName;
import one.xingyi.core.names.IServerNames;
import one.xingyi.core.validation.Result;

public class ServerDom {
    public final PackageAndClassName originalDefn;
    public final PackageAndClassName serverName;
    public final CodeDom codeDom;

    public static Result<ElementFail, ServerDom> create(IServerNames names, Element element, CodeDom codeDom) {
        String rawName = element.asType().toString();
        PackageAndClassName originalDefn = new PackageAndClassName(rawName);
        PackageAndClassName serverName = originalDefn.mapName(s -> s.substring(1, s.length() - 4));
        return Result.succeed(new ServerDom(originalDefn, serverName, codeDom));
    }

    public ServerDom(PackageAndClassName originalDefn, PackageAndClassName serverName, CodeDom codeDom) {
        this.originalDefn = originalDefn;
        this.serverName = serverName;
        this.codeDom = codeDom;
    }

    public String toString() {
        return "ServerDom(originalDefn=" + this.originalDefn + ", serverName=" + this.serverName + ", codeDom=" + this.codeDom + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerDom)) {
            return false;
        }
        ServerDom other = (ServerDom)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PackageAndClassName this$originalDefn = this.originalDefn;
        PackageAndClassName other$originalDefn = other.originalDefn;
        if (this$originalDefn == null ? other$originalDefn != null : !((Object)this$originalDefn).equals(other$originalDefn)) {
            return false;
        }
        PackageAndClassName this$serverName = this.serverName;
        PackageAndClassName other$serverName = other.serverName;
        if (this$serverName == null ? other$serverName != null : !((Object)this$serverName).equals(other$serverName)) {
            return false;
        }
        CodeDom this$codeDom = this.codeDom;
        CodeDom other$codeDom = other.codeDom;
        return !(this$codeDom == null ? other$codeDom != null : !this$codeDom.equals(other$codeDom));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerDom;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PackageAndClassName $originalDefn = this.originalDefn;
        result = result * 59 + ($originalDefn == null ? 43 : ((Object)$originalDefn).hashCode());
        PackageAndClassName $serverName = this.serverName;
        result = result * 59 + ($serverName == null ? 43 : ((Object)$serverName).hashCode());
        CodeDom $codeDom = this.codeDom;
        result = result * 59 + ($codeDom == null ? 43 : $codeDom.hashCode());
        return result;
    }
}

