/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.endpoints;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import one.xingyi.core.endpoints.EndPoint;
import one.xingyi.core.endpoints.MethodPathAndDescription;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.http.ServiceResponse;
import one.xingyi.core.utils.Lists;

class ComposeEndPoints
implements EndPoint {
    final List<EndPoint> endpoints;
    final boolean debug;

    public ComposeEndPoints(List<EndPoint> endpoints, boolean debug) {
        this.endpoints = endpoints;
        this.debug = debug;
        for (EndPoint endPoint : endpoints) {
            if (endPoint != null) continue;
            throw new NullPointerException(endpoints.toString());
        }
    }

    CompletableFuture<Optional<ServiceResponse>> recurse(ServiceRequest serviceRequest, int index) {
        if (index >= this.endpoints.size()) {
            if (this.debug) {
                System.out.println("Could not find " + serviceRequest + "\n" + Lists.mapJoin(this.endpoints, "\n", e -> e.description().toString()));
            }
            return CompletableFuture.completedFuture(Optional.empty());
        }
        EndPoint endPoint = this.endpoints.get(index);
        if (this.debug) {
            System.out.println("Checking end point " + endPoint.description() + " with " + serviceRequest);
        }
        return ((CompletableFuture)endPoint.apply(serviceRequest)).thenCompose(op -> {
            if (op.isEmpty()) {
                return this.recurse(serviceRequest, index + 1);
            }
            if (this.debug) {
                System.out.println("...... found it" + endPoint.description() + " for " + serviceRequest);
            }
            return CompletableFuture.completedFuture(op);
        });
    }

    @Override
    public CompletableFuture<Optional<ServiceResponse>> apply(ServiceRequest serviceRequest) {
        return this.recurse(serviceRequest, 0);
    }

    @Override
    public List<MethodPathAndDescription> description() {
        return Lists.flatMap(this.endpoints, EndPoint::description);
    }

    public String toString() {
        return "ComposeEndPoints(endpoints=" + this.endpoints + ", debug=" + this.debug + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComposeEndPoints)) {
            return false;
        }
        ComposeEndPoints other = (ComposeEndPoints)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<EndPoint> this$endpoints = this.endpoints;
        List<EndPoint> other$endpoints = other.endpoints;
        if (this$endpoints == null ? other$endpoints != null : !((Object)this$endpoints).equals(other$endpoints)) {
            return false;
        }
        return this.debug == other.debug;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ComposeEndPoints;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<EndPoint> $endpoints = this.endpoints;
        result = result * 59 + ($endpoints == null ? 43 : ((Object)$endpoints).hashCode());
        result = result * 59 + (this.debug ? 79 : 97);
        return result;
    }
}

