/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.endpoints;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import one.xingyi.core.endpoints.ComposeEndPoints;
import one.xingyi.core.endpoints.EndpointAcceptor0;
import one.xingyi.core.endpoints.EndpointContext;
import one.xingyi.core.endpoints.MethodAndPathDescription;
import one.xingyi.core.endpoints.MethodPathAndDescription;
import one.xingyi.core.endpoints.PrintlnEndpoint;
import one.xingyi.core.endpoints.StaticEndpoint;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.http.ServiceResponse;
import one.xingyi.core.utils.DigestAndString;
import one.xingyi.core.utils.Digestor;
import one.xingyi.core.utils.Lists;
import one.xingyi.core.utils.WrappedException;

public interface EndPoint
extends Function<ServiceRequest, CompletableFuture<Optional<ServiceResponse>>>,
MethodAndPathDescription {
    @Override
    public List<MethodPathAndDescription> description();

    public static Function<ServiceRequest, String> defaultNotFound(EndPoint endPoint) {
        return sr -> "Cannot find response for\n" + sr.toString() + "\nLegal Endpoints are\n   " + Lists.mapJoin(endPoint.description(), "\n   ", Objects::toString);
    }

    public static Function<ServiceRequest, CompletableFuture<ServiceResponse>> toKliesli(EndPoint original) {
        return EndPoint.toKliesli(original, EndPoint.defaultNotFound(original));
    }

    public static Function<ServiceRequest, CompletableFuture<ServiceResponse>> toKliesli(Function<ServiceRequest, CompletableFuture<Optional<ServiceResponse>>> original, Function<ServiceRequest, String> bodyIfNotFound) {
        if (original == null) {
            throw new NullPointerException();
        }
        return sr -> {
            try {
                return ((CompletableFuture)((CompletableFuture)original.apply((ServiceRequest)sr)).thenApply(opt -> opt.orElse(ServiceResponse.notFound((String)bodyIfNotFound.apply((ServiceRequest)sr))))).exceptionally(EndPoint::defaultErrorHandler);
            }
            catch (Exception e) {
                return CompletableFuture.completedFuture(EndPoint.defaultErrorHandler(e));
            }
        };
    }

    public static ServiceResponse defaultErrorHandler(Throwable e) {
        System.out.println("Dumping error from inside completable future in toKliesli");
        Throwable actual = WrappedException.unWrap(e);
        actual.printStackTrace();
        return EndPoint.internalError(actual);
    }

    public static ServiceResponse internalError(Throwable e) {
        return ServiceResponse.html(500, e.getClass().getName() + "\n" + e.getMessage());
    }

    public static EndPoint compose(List<EndPoint> endPoints) {
        return new ComposeEndPoints(endPoints, false);
    }

    public static EndPoint compose(List<EndPoint> endPoints, boolean debug) {
        return new ComposeEndPoints(endPoints, debug);
    }

    public static <J> EndPoint javascript(EndpointContext<J> context, String prefix) {
        String javascript = (String)context.javascriptDetailsToString.apply(context.javascriptStore.find(List.of()));
        DigestAndString digestAndString = (DigestAndString)Digestor.digestor().apply(javascript);
        return new StaticEndpoint(EndpointAcceptor0.exact("get", prefix + "/" + digestAndString.digest, "javascript endpoint"), new ServiceResponse(200, digestAndString.string, List.of()));
    }

    public static EndPoint staticEndpoint(EndpointAcceptor0 acceptor, ServiceResponse serviceResponse) {
        return new StaticEndpoint(acceptor, serviceResponse);
    }

    public static EndPoint printlnLog(EndPoint endPoint) {
        return new PrintlnEndpoint(endPoint);
    }

    public static EndPoint printlnDetailsLog(EndPoint endPoint) {
        return new PrintlnEndpoint(endPoint);
    }
}

