/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.endpoints;

import java.util.List;
import one.xingyi.core.endpoints.EndpointContext;
import one.xingyi.core.endpoints.IMergeJavascriptAndJson;
import one.xingyi.core.javascript.JavascriptDetailsToString;
import one.xingyi.core.javascript.JavascriptStore;
import one.xingyi.core.marshelling.JsonParserAndWriter;
import one.xingyi.core.sdk.IXingYiServerCompanion;
import one.xingyi.core.utils.Files;

public class EndpointConfig<J> {
    public final String rootJavascript;
    public final JsonParserAndWriter<J> parserAndWriter;
    public final String protocol;
    public final JavascriptDetailsToString javascriptDetailsToString;
    public final IMergeJavascriptAndJson mergeJavascriptAndJson;

    public EndpointConfig<J> withMoreJavascript(String javascript) {
        return new EndpointConfig<J>(this.rootJavascript + "\n\n\n" + javascript, this.parserAndWriter, this.protocol, this.javascriptDetailsToString, this.mergeJavascriptAndJson);
    }

    public static <J> EndpointConfig<J> defaultConfig(JsonParserAndWriter<J> parserAndWriter) {
        return new EndpointConfig<J>(Files.getText("header.js"), parserAndWriter, "http://", JavascriptDetailsToString.simple, IMergeJavascriptAndJson.byLinks);
    }

    public EndpointContext<J> from(List<IXingYiServerCompanion<?, ?>> companions) {
        return new EndpointContext<J>(JavascriptStore.fromEntities(this.rootJavascript, companions), this.javascriptDetailsToString, this.mergeJavascriptAndJson, this.parserAndWriter, this.protocol);
    }

    public EndpointConfig(String rootJavascript, JsonParserAndWriter<J> parserAndWriter, String protocol, JavascriptDetailsToString javascriptDetailsToString, IMergeJavascriptAndJson mergeJavascriptAndJson) {
        this.rootJavascript = rootJavascript;
        this.parserAndWriter = parserAndWriter;
        this.protocol = protocol;
        this.javascriptDetailsToString = javascriptDetailsToString;
        this.mergeJavascriptAndJson = mergeJavascriptAndJson;
    }

    public String toString() {
        return "EndpointConfig(rootJavascript=" + this.rootJavascript + ", parserAndWriter=" + this.parserAndWriter + ", protocol=" + this.protocol + ", javascriptDetailsToString=" + this.javascriptDetailsToString + ", mergeJavascriptAndJson=" + this.mergeJavascriptAndJson + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EndpointConfig)) {
            return false;
        }
        EndpointConfig other = (EndpointConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$rootJavascript = this.rootJavascript;
        String other$rootJavascript = other.rootJavascript;
        if (this$rootJavascript == null ? other$rootJavascript != null : !this$rootJavascript.equals(other$rootJavascript)) {
            return false;
        }
        JsonParserAndWriter<J> this$parserAndWriter = this.parserAndWriter;
        JsonParserAndWriter<J> other$parserAndWriter = other.parserAndWriter;
        if (this$parserAndWriter == null ? other$parserAndWriter != null : !this$parserAndWriter.equals(other$parserAndWriter)) {
            return false;
        }
        String this$protocol = this.protocol;
        String other$protocol = other.protocol;
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        JavascriptDetailsToString this$javascriptDetailsToString = this.javascriptDetailsToString;
        JavascriptDetailsToString other$javascriptDetailsToString = other.javascriptDetailsToString;
        if (this$javascriptDetailsToString == null ? other$javascriptDetailsToString != null : !this$javascriptDetailsToString.equals(other$javascriptDetailsToString)) {
            return false;
        }
        IMergeJavascriptAndJson this$mergeJavascriptAndJson = this.mergeJavascriptAndJson;
        IMergeJavascriptAndJson other$mergeJavascriptAndJson = other.mergeJavascriptAndJson;
        return !(this$mergeJavascriptAndJson == null ? other$mergeJavascriptAndJson != null : !this$mergeJavascriptAndJson.equals(other$mergeJavascriptAndJson));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EndpointConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $rootJavascript = this.rootJavascript;
        result = result * 59 + ($rootJavascript == null ? 43 : $rootJavascript.hashCode());
        JsonParserAndWriter<J> $parserAndWriter = this.parserAndWriter;
        result = result * 59 + ($parserAndWriter == null ? 43 : $parserAndWriter.hashCode());
        String $protocol = this.protocol;
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        JavascriptDetailsToString $javascriptDetailsToString = this.javascriptDetailsToString;
        result = result * 59 + ($javascriptDetailsToString == null ? 43 : $javascriptDetailsToString.hashCode());
        IMergeJavascriptAndJson $mergeJavascriptAndJson = this.mergeJavascriptAndJson;
        result = result * 59 + ($mergeJavascriptAndJson == null ? 43 : $mergeJavascriptAndJson.hashCode());
        return result;
    }
}

