/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.endpoints;

import java.util.List;
import java.util.function.Function;
import one.xingyi.core.endpoints.IMergeJavascriptAndJson;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.javascript.JavascriptDetailsToString;
import one.xingyi.core.javascript.JavascriptStore;
import one.xingyi.core.marshelling.ContextForJson;
import one.xingyi.core.marshelling.HasJson;
import one.xingyi.core.marshelling.HasJsonWithLinks;
import one.xingyi.core.marshelling.JsonParserAndWriter;
import one.xingyi.core.mediatype.ServerMediaTypeContext;
import one.xingyi.core.utils.IdAndValue;

public class EndpointContext<J>
implements ServerMediaTypeContext<J> {
    public final JavascriptStore javascriptStore;
    public final JavascriptDetailsToString javascriptDetailsToString;
    public final IMergeJavascriptAndJson mergeJavascriptAndJson;
    public final JsonParserAndWriter<J> parserAndWriter;
    public final String protocol;

    public <Entity extends HasJson<ContextForJson>> String resultBody(ServiceRequest serviceRequest, String codeUrl, Entity entity) {
        ContextForJson context = ContextForJson.forServiceRequest(this.protocol, serviceRequest);
        String json = this.parserAndWriter.fromJ(entity.toJson(this.parserAndWriter, (ContextForJson)context));
        return this.resultBodyForJson(context.template(codeUrl), json);
    }

    public <Entity extends HasJsonWithLinks<ContextForJson, Entity>> String resultBodyWithLinks(ServiceRequest serviceRequest, String codeUrl, Entity entity, Function<Entity, String> stateFn) {
        ContextForJson context = ContextForJson.forServiceRequest(this.protocol, serviceRequest);
        String json = this.parserAndWriter.fromJ(entity.toJsonWithLinks(this.parserAndWriter, context, stateFn));
        return this.resultBodyForJson(context.template(codeUrl), json);
    }

    public <Entity extends HasJsonWithLinks<ContextForJson, Entity>> String resultBodyForIdAndValue(ServiceRequest serviceRequest, String codeUrl, IdAndValue<Entity> entity, Function<Entity, String> stateFn) {
        ContextForJson contextForJson = ContextForJson.forServiceRequest(this.protocol, serviceRequest);
        J j = IdAndValue.toJson(entity, this.parserAndWriter, contextForJson, stateFn);
        return this.resultBodyForJson(contextForJson.template(codeUrl), this.parserAndWriter.fromJ(j));
    }

    String resultBodyForJson(String codeUrl, String json) {
        String javascript = (String)this.javascriptDetailsToString.apply(this.javascriptStore.find(List.of()));
        return this.mergeJavascriptAndJson.merge(codeUrl, javascript, json);
    }

    @Override
    public JsonParserAndWriter<J> parserAndWriter() {
        return this.parserAndWriter;
    }

    @Override
    public JavascriptStore javascriptStore() {
        return this.javascriptStore;
    }

    @Override
    public JavascriptDetailsToString javascriptDetailsToString() {
        return this.javascriptDetailsToString;
    }

    @Override
    public String protocol() {
        return this.protocol;
    }

    public EndpointContext(JavascriptStore javascriptStore, JavascriptDetailsToString javascriptDetailsToString, IMergeJavascriptAndJson mergeJavascriptAndJson, JsonParserAndWriter<J> parserAndWriter, String protocol) {
        this.javascriptStore = javascriptStore;
        this.javascriptDetailsToString = javascriptDetailsToString;
        this.mergeJavascriptAndJson = mergeJavascriptAndJson;
        this.parserAndWriter = parserAndWriter;
        this.protocol = protocol;
    }

    public String toString() {
        return "EndpointContext(javascriptStore=" + this.javascriptStore + ", javascriptDetailsToString=" + this.javascriptDetailsToString + ", mergeJavascriptAndJson=" + this.mergeJavascriptAndJson + ", parserAndWriter=" + this.parserAndWriter + ", protocol=" + this.protocol + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EndpointContext)) {
            return false;
        }
        EndpointContext other = (EndpointContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JavascriptStore this$javascriptStore = this.javascriptStore;
        JavascriptStore other$javascriptStore = other.javascriptStore;
        if (this$javascriptStore == null ? other$javascriptStore != null : !this$javascriptStore.equals(other$javascriptStore)) {
            return false;
        }
        JavascriptDetailsToString this$javascriptDetailsToString = this.javascriptDetailsToString;
        JavascriptDetailsToString other$javascriptDetailsToString = other.javascriptDetailsToString;
        if (this$javascriptDetailsToString == null ? other$javascriptDetailsToString != null : !this$javascriptDetailsToString.equals(other$javascriptDetailsToString)) {
            return false;
        }
        IMergeJavascriptAndJson this$mergeJavascriptAndJson = this.mergeJavascriptAndJson;
        IMergeJavascriptAndJson other$mergeJavascriptAndJson = other.mergeJavascriptAndJson;
        if (this$mergeJavascriptAndJson == null ? other$mergeJavascriptAndJson != null : !this$mergeJavascriptAndJson.equals(other$mergeJavascriptAndJson)) {
            return false;
        }
        JsonParserAndWriter<J> this$parserAndWriter = this.parserAndWriter;
        JsonParserAndWriter<J> other$parserAndWriter = other.parserAndWriter;
        if (this$parserAndWriter == null ? other$parserAndWriter != null : !this$parserAndWriter.equals(other$parserAndWriter)) {
            return false;
        }
        String this$protocol = this.protocol;
        String other$protocol = other.protocol;
        return !(this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EndpointContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JavascriptStore $javascriptStore = this.javascriptStore;
        result = result * 59 + ($javascriptStore == null ? 43 : $javascriptStore.hashCode());
        JavascriptDetailsToString $javascriptDetailsToString = this.javascriptDetailsToString;
        result = result * 59 + ($javascriptDetailsToString == null ? 43 : $javascriptDetailsToString.hashCode());
        IMergeJavascriptAndJson $mergeJavascriptAndJson = this.mergeJavascriptAndJson;
        result = result * 59 + ($mergeJavascriptAndJson == null ? 43 : $mergeJavascriptAndJson.hashCode());
        JsonParserAndWriter<J> $parserAndWriter = this.parserAndWriter;
        result = result * 59 + ($parserAndWriter == null ? 43 : $parserAndWriter.hashCode());
        String $protocol = this.protocol;
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        return result;
    }
}

