/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.endpoints;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import one.xingyi.core.endpoints.EndPoint;
import one.xingyi.core.endpoints.MethodPathAndDescription;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.http.ServiceResponse;
import one.xingyi.core.marshelling.IXingYiResponseSplitter;
import one.xingyi.core.utils.Strings;

class PrintlnEndpoint
implements EndPoint {
    final EndPoint endPoint;

    @Override
    public List<MethodPathAndDescription> description() {
        return this.endPoint.description();
    }

    @Override
    public CompletableFuture<Optional<ServiceResponse>> apply(ServiceRequest sr) {
        return ((CompletableFuture)this.endPoint.apply(sr)).thenApply(optRes -> {
            String result = optRes.map(r -> {
                if (r.body.contains("\n---------\n")) {
                    return IXingYiResponseSplitter.rawSplit((ServiceResponse)r).data;
                }
                return sr.body;
            }).orElse("??");
            System.out.println(Strings.padRight(sr.method, 5) + Strings.padRight(sr.uri.toString(), 80) + "    " + optRes.map(r -> r.statusCode).orElse(0) + " " + result);
            return optRes;
        });
    }

    public PrintlnEndpoint(EndPoint endPoint) {
        this.endPoint = endPoint;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrintlnEndpoint)) {
            return false;
        }
        PrintlnEndpoint other = (PrintlnEndpoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EndPoint this$endPoint = this.endPoint;
        EndPoint other$endPoint = other.endPoint;
        return !(this$endPoint == null ? other$endPoint != null : !this$endPoint.equals(other$endPoint));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PrintlnEndpoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EndPoint $endPoint = this.endPoint;
        result = result * 59 + ($endPoint == null ? 43 : $endPoint.hashCode());
        return result;
    }

    public String toString() {
        return "PrintlnEndpoint(endPoint=" + this.endPoint + ")";
    }
}

