/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.endpoints;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import one.xingyi.core.endpoints.EndpointResult;
import one.xingyi.core.endpoints.IResourceEndPoint;
import one.xingyi.core.endpoints.IResourceEndpointAcceptor;
import one.xingyi.core.endpoints.MethodPathAndDescription;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.http.ServiceResponse;
import one.xingyi.core.sdk.IXingYiResource;

class ResourceEndPoint<Entity extends IXingYiResource, Request, Result>
implements IResourceEndPoint<Entity, Request, Result> {
    final IResourceEndpointAcceptor<Request> acceptor;
    final Function<Request, CompletableFuture<Result>> fn;
    final EndpointResult<Result> endpointResult;

    @Override
    public CompletableFuture<Optional<ServiceResponse>> apply(ServiceRequest serviceRequest) {
        return this.acceptor.andIfMatches(from -> this.fn.apply(from).thenApply(result -> this.endpointResult.apply(serviceRequest, result))).apply(serviceRequest);
    }

    @Override
    public List<MethodPathAndDescription> description() {
        return this.acceptor.description();
    }

    public ResourceEndPoint(IResourceEndpointAcceptor<Request> acceptor, Function<Request, CompletableFuture<Result>> fn, EndpointResult<Result> endpointResult) {
        this.acceptor = acceptor;
        this.fn = fn;
        this.endpointResult = endpointResult;
    }
}

