/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.filemaker;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import one.xingyi.core.annotationProcessors.ActionsDom;
import one.xingyi.core.annotationProcessors.PostDom;
import one.xingyi.core.codeDom.FieldDom;
import one.xingyi.core.codeDom.ViewDomAndResourceDomField;
import one.xingyi.core.filemaker.BookmarkUrlAndActionsDom;
import one.xingyi.core.monad.MonadDefn;
import one.xingyi.core.utils.Lists;
import one.xingyi.core.utils.Optionals;
import one.xingyi.core.utils.Strings;

public interface CreateViewMethods {
    public MonadDefn monadDefn();

    default public List<String> accessors(String interfaceName, ViewDomAndResourceDomField viewDomAndEntityDom) {
        FieldDom dom = viewDomAndEntityDom.viewDomField;
        ArrayList<String> result = new ArrayList<String>();
        result.add("//" + dom.typeDom);
        result.add(dom.typeDom.forView() + " " + dom.name + "();");
        if (!dom.readOnly && !viewDomAndEntityDom.entityDomField.map(e -> e.readOnly).orElse(false).booleanValue()) {
            result.add(interfaceName + " with" + dom.name + "(" + dom.typeDom.forView() + " " + dom.name + ");");
        }
        return result;
    }

    default public List<String> getMethod(String viewName, String companionName) {
        return List.of("public static <T> " + this.monadDefn().simpleClassName() + "<T> get(HttpService" + this.monadDefn().simpleClassName() + " service, String id, Function<" + viewName + ", T> fn){return service.get(" + companionName + ",id,fn);}");
    }

    default public List<String> optionalGetMethod(String viewName, String companionName) {
        return List.of("public static <T> " + this.monadDefn().simpleClassName() + "<Optional<T>> getOptional(HttpService" + this.monadDefn().simpleClassName() + " service, String id, Function<" + viewName + ", T> fn){return service.getOptional(" + companionName + ",id,fn);}");
    }

    default public List<String> editMethod(String viewName, String companionName) {
        return List.of("public static " + this.monadDefn().simpleClassName() + "<" + viewName + " > edit(HttpService" + this.monadDefn().simpleClassName() + " service, String id, Function<" + viewName + "," + viewName + "> fn){return service.edit(" + companionName + ",id, fn);}");
    }

    default public List<String> prototypeNoIdMethod(String viewName, String companionName, String prototypeId) {
        return List.of("public static " + this.monadDefn().simpleClassName() + "<IdAndValue<" + viewName + ">> prototypeNoId(HttpService" + this.monadDefn().simpleClassName() + " service,  Function<" + viewName + "," + viewName + "> fn){return service.prototypeNoId(" + companionName + "," + Strings.quote(prototypeId) + ",fn);}");
    }

    default public List<String> prototypeMethod(String viewName, String companionName, String prototypeId) {
        return List.of("public static " + this.monadDefn().simpleClassName() + "<" + viewName + " > prototype(HttpService" + this.monadDefn().simpleClassName() + " service, String id, Function<" + viewName + "," + viewName + "> fn){return service.prototype(" + companionName + "," + Strings.quote(prototypeId) + ",id,fn);}");
    }

    default public List<String> deleteMethod(String companionName) {
        return List.of("public static " + this.monadDefn().simpleClassName() + "<Boolean> delete(HttpService" + this.monadDefn().simpleClassName() + " service, String id){return service.delete(" + companionName + ",id);}");
    }

    default public List<String> createMethod(String viewName, String companionName) {
        return List.of("public static " + this.monadDefn().simpleClassName() + "<" + viewName + "> create(HttpService" + this.monadDefn().simpleClassName() + " service, String id){return service.create(" + companionName + ",id);}");
    }

    default public List<String> createWithoutIdMethod(String viewName, String companionName) {
        return List.of("public static " + this.monadDefn().simpleClassName() + "<IdAndValue<" + viewName + ">> create(HttpService" + this.monadDefn().simpleClassName() + " service, " + viewName + " view){return service.createWithoutId(" + companionName + ", view);}");
    }

    default public List<String> getRemoteAccessors(String viewName, String companionName, Optional<BookmarkUrlAndActionsDom> bookmarkUrlAndActionsDom) {
        return Optionals.fold(bookmarkUrlAndActionsDom, () -> List.of(), b -> {
            ActionsDom actionsDom = b.actionsDom;
            return Lists.append(Optionals.flatMap(actionsDom.getDom, dom -> this.getMethod(viewName, companionName)), Optionals.flatMap(actionsDom.optionalGetDom, dom -> this.optionalGetMethod(viewName, companionName)), Optionals.flatMap(actionsDom.putDom, dom -> this.editMethod(viewName, companionName)), Optionals.flatMap(actionsDom.createDom, dom -> this.createMethod(viewName, companionName)), Optionals.flatMap(actionsDom.createWithoutIdDom, dom -> this.createWithoutIdMethod(viewName, companionName)), Optionals.flatMap(actionsDom.deleteDom, dom -> this.deleteMethod(companionName)), Optionals.flatMap(actionsDom.prototypeDom, dom -> this.prototypeMethod(viewName, companionName, dom.prototypeId)), Optionals.flatMap(actionsDom.prototypeNoIdDom, dom -> this.prototypeNoIdMethod(viewName, companionName, dom.prototypeId)));
        });
    }

    default public List<String> postMethod(PostDom postDom, String viewName, String companionName) {
        return List.of("//The optional is because if the command needs a state, and that entity isn't in that state it will not be executed", "public static " + this.monadDefn().simpleClassName() + "<" + viewName + ">. " + postDom.action + "(HttpService service, String id){return service.post(" + companionName + "," + Strings.quote(postDom.action) + ",id);}");
    }
}

