/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.http;

import java.net.URI;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import one.xingyi.core.http.Header;
import one.xingyi.core.utils.Lists;
import one.xingyi.core.utils.Strings;

public class ServiceRequest {
    public final String method;
    public final String originalUrl;
    public final URI uri;
    public final String path;
    public final List<Header> headers;
    public final String body;
    private List<String> urlSegments = null;

    public static Function<ServiceRequest, String> ripId(String bookmark, Function<ServiceRequest, RuntimeException> ifNotPresent) {
        Function<String, Optional<String>> ripper = Strings.ripIdFromPath(bookmark);
        return from -> (String)((Optional)ripper.apply(from.uri.getPath())).orElseThrow(() -> (RuntimeException)ifNotPresent.apply((ServiceRequest)from));
    }

    public static ServiceRequest sr(String method, String path) {
        return new ServiceRequest(method, path, List.of(), "");
    }

    public static ServiceRequest sr(String method, String path, String acceptHeader) {
        return new ServiceRequest(method, path, List.of(new Header("accept", acceptHeader)), "");
    }

    public ServiceRequest(String method, String url, List<Header> headers, String body) {
        this.method = method;
        this.originalUrl = url;
        if (url.equalsIgnoreCase("invalid")) {
            throw new RuntimeException("found invalid");
        }
        this.uri = URI.create(url);
        this.path = this.uri.getPath();
        this.headers = headers;
        this.body = body;
    }

    public int segmentsCount() {
        return this.urlSegments().size();
    }

    public List<String> urlSegments() {
        if (this.urlSegments == null) {
            this.urlSegments = Lists.map(Arrays.asList(this.uri.getPath().split("/")), s -> URLDecoder.decode(s, "UTF-8"));
        }
        return this.urlSegments;
    }

    public String lastSegment() {
        return this.urlSegments().get(this.urlSegments().size() - 1);
    }

    public Optional<String> header(String header) {
        for (Header h : this.headers) {
            if (!h.name.equalsIgnoreCase(header)) continue;
            return Optional.of(h.value);
        }
        return Optional.empty();
    }

    public String toString() {
        return "ServiceRequest(method=" + this.method + ", originalUrl=" + this.originalUrl + ", uri=" + this.uri + ", path=" + this.path + ", headers=" + this.headers + ", body=" + this.body + ", urlSegments=" + this.urlSegments + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceRequest)) {
            return false;
        }
        ServiceRequest other = (ServiceRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$method = this.method;
        String other$method = other.method;
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$originalUrl = this.originalUrl;
        String other$originalUrl = other.originalUrl;
        if (this$originalUrl == null ? other$originalUrl != null : !this$originalUrl.equals(other$originalUrl)) {
            return false;
        }
        URI this$uri = this.uri;
        URI other$uri = other.uri;
        if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
            return false;
        }
        String this$path = this.path;
        String other$path = other.path;
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        List<Header> this$headers = this.headers;
        List<Header> other$headers = other.headers;
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$body = this.body;
        String other$body = other.body;
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        List<String> this$urlSegments = this.urlSegments;
        List<String> other$urlSegments = other.urlSegments;
        return !(this$urlSegments == null ? other$urlSegments != null : !((Object)this$urlSegments).equals(other$urlSegments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $method = this.method;
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $originalUrl = this.originalUrl;
        result = result * 59 + ($originalUrl == null ? 43 : $originalUrl.hashCode());
        URI $uri = this.uri;
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        String $path = this.path;
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        List<Header> $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $body = this.body;
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        List<String> $urlSegments = this.urlSegments;
        result = result * 59 + ($urlSegments == null ? 43 : ((Object)$urlSegments).hashCode());
        return result;
    }
}

