/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.http;

import java.util.Arrays;
import java.util.List;
import one.xingyi.core.http.Header;

public class ServiceResponse {
    public final int statusCode;
    public final String body;
    public final List<Header> headers;

    public static <J> ServiceResponse jsonString(int status, String json) {
        return new ServiceResponse(status, json, Arrays.asList(new Header("Content-type", "application/parserAndWriter")));
    }

    public static ServiceResponse html(int status, String body) {
        return new ServiceResponse(status, body, Arrays.asList(new Header("Content-type", "text/html")));
    }

    public static ServiceResponse notFound(String msg) {
        return ServiceResponse.html(404, msg);
    }

    public String toString() {
        return "ServiceResponse(statusCode=" + this.statusCode + ", body=" + this.body + ", headers=" + this.headers + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceResponse)) {
            return false;
        }
        ServiceResponse other = (ServiceResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.statusCode != other.statusCode) {
            return false;
        }
        String this$body = this.body;
        String other$body = other.body;
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        List<Header> this$headers = this.headers;
        List<Header> other$headers = other.headers;
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.statusCode;
        String $body = this.body;
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        List<Header> $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    public ServiceResponse(int statusCode, String body, List<Header> headers) {
        this.statusCode = statusCode;
        this.body = body;
        this.headers = headers;
    }
}

