/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.mediatype;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import one.xingyi.core.endpoints.BookmarkCodeAndUrlPattern;
import one.xingyi.core.endpoints.EndPoint;
import one.xingyi.core.endpoints.EndpointResult;
import one.xingyi.core.endpoints.EntityMediaTypeEndpoint;
import one.xingyi.core.endpoints.IResourceEndPoint;
import one.xingyi.core.endpoints.IResourceEndpointAcceptor;
import one.xingyi.core.endpoints.IdAndEntityMediaTypeEndpoint;
import one.xingyi.core.endpoints.OptionalEntityMediaTypeEndpoint;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.mediatype.IMediaTypeServerDefn;
import one.xingyi.core.mediatype.IResourceEndpoints;
import one.xingyi.core.sdk.IXingYiResource;
import one.xingyi.core.utils.IdAndValue;

class MediaTypeResourceEndpoints<Entity extends IXingYiResource>
implements IResourceEndpoints<Entity> {
    final String protocol;
    final IMediaTypeServerDefn<Entity> mediaTypeServerDefn;
    final BookmarkCodeAndUrlPattern bookmarkCodeAndUrlPattern;
    final Function<Entity, String> stateFn;

    @Override
    public EndPoint put(BiFunction<ServiceRequest, String, IdAndValue<Entity>> fromFn, Function<IdAndValue<Entity>, CompletableFuture<Entity>> fn) {
        return new EntityMediaTypeEndpoint<IdAndValue<Entity>, Entity>(IResourceEndpointAcceptor.apply("put", this.bookmarkCodeAndUrlPattern.urlPattern, fromFn, MediaTypeResourceEndpoints.class.getSimpleName() + "/put"), fn, this.protocol, 200, this.mediaTypeServerDefn, this.stateFn);
    }

    @Override
    public EndPoint getOptional(Function<String, CompletableFuture<Optional<Entity>>> fn) {
        return new OptionalEntityMediaTypeEndpoint<String, Entity>(IResourceEndpointAcceptor.apply("get", this.bookmarkCodeAndUrlPattern.urlPattern, (sr, s) -> s, MediaTypeResourceEndpoints.class.getSimpleName() + "/getOptional"), fn, this.protocol, 200, this.mediaTypeServerDefn, this.stateFn);
    }

    @Override
    public EndPoint get(Function<String, CompletableFuture<Entity>> fn) {
        return new EntityMediaTypeEndpoint<String, Entity>(IResourceEndpointAcceptor.apply("get", this.bookmarkCodeAndUrlPattern.urlPattern, (sr, s) -> s, MediaTypeResourceEndpoints.class.getSimpleName() + "/get"), fn, this.protocol, 200, this.mediaTypeServerDefn, this.stateFn);
    }

    @Override
    public EndPoint delete(Function<String, CompletableFuture<Boolean>> fn) {
        return IResourceEndPoint.create(IResourceEndpointAcceptor.apply("delete", this.bookmarkCodeAndUrlPattern.urlPattern, (sr, s) -> s, MediaTypeResourceEndpoints.class.getSimpleName() + "/delete"), fn, EndpointResult.createForNonEntity(200, r -> r.toString()));
    }

    @Override
    public EndPoint createWithId(Function<String, CompletableFuture<Entity>> fn) {
        return new EntityMediaTypeEndpoint<String, Entity>(IResourceEndpointAcceptor.apply("post", this.bookmarkCodeAndUrlPattern.urlPattern, (sr, s) -> s, MediaTypeResourceEndpoints.class.getSimpleName() + "/createWithId"), fn, this.protocol, 200, this.mediaTypeServerDefn, this.stateFn);
    }

    @Override
    public EndPoint createWithoutId(String path, Function<ServiceRequest, Entity> fromFn, Function<Entity, CompletableFuture<IdAndValue<Entity>>> createFn) {
        return new IdAndEntityMediaTypeEndpoint<Entity, Entity>(IResourceEndpointAcceptor.create("post", path, fromFn, MediaTypeResourceEndpoints.class.getSimpleName() + "/createWithoutId"), createFn, this.protocol, 201, this.mediaTypeServerDefn, this.stateFn);
    }

    @Override
    public EndPoint post(String path, List<String> validStates, Function<String, CompletableFuture<Entity>> postFn) {
        return new EntityMediaTypeEndpoint<String, Entity>(IResourceEndpointAcceptor.apply("post", path, (sr, s) -> s, MediaTypeResourceEndpoints.class.getSimpleName() + "/post"), postFn, this.protocol, 200, this.mediaTypeServerDefn, this.stateFn);
    }

    public MediaTypeResourceEndpoints(String protocol, IMediaTypeServerDefn<Entity> mediaTypeServerDefn, BookmarkCodeAndUrlPattern bookmarkCodeAndUrlPattern, Function<Entity, String> stateFn) {
        this.protocol = protocol;
        this.mediaTypeServerDefn = mediaTypeServerDefn;
        this.bookmarkCodeAndUrlPattern = bookmarkCodeAndUrlPattern;
        this.stateFn = stateFn;
    }
}

