/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.mediatype;

import java.util.List;
import java.util.function.Function;
import one.xingyi.core.marshelling.ContextForJson;
import one.xingyi.core.marshelling.DataToBeSentToClient;
import one.xingyi.core.marshelling.HasJsonWithLinks;
import one.xingyi.core.marshelling.JsonParserAndWriter;
import one.xingyi.core.marshelling.MakesFromJson;
import one.xingyi.core.mediatype.IXingYiServerMediaTypeDefn;
import one.xingyi.core.sdk.IXingYiResource;
import one.xingyi.core.utils.IdAndValue;
import one.xingyi.core.utils.Strings;

abstract class SimpleServerMediaTypeDefn<J, Entity extends IXingYiResource & HasJsonWithLinks<ContextForJson, Entity>>
implements IXingYiServerMediaTypeDefn<Entity> {
    final String prefix;
    final MakesFromJson<Entity> makesFromJson;
    final JsonParserAndWriter<J> parserAndWriter;

    public SimpleServerMediaTypeDefn(MakesFromJson<Entity> makesFromJson, JsonParserAndWriter<J> parserAndWriter, String prefix, String entityName) {
        this.makesFromJson = makesFromJson;
        this.parserAndWriter = parserAndWriter;
        this.prefix = (prefix + "." + entityName).toLowerCase();
    }

    @Override
    public List<String> lensNames(String acceptHeader) {
        String lowerCaseAcceptHeader = acceptHeader.toLowerCase();
        if (lowerCaseAcceptHeader.startsWith(this.prefix)) {
            String withoutPrefix = lowerCaseAcceptHeader.substring(this.prefix.length());
            if (withoutPrefix.length() == 0) {
                return List.of();
            }
            return Strings.split(withoutPrefix.substring(1), "\\.");
        }
        throw new RuntimeException("Illegal access of media type. Must start with " + this.prefix + " but was " + lowerCaseAcceptHeader);
    }

    @Override
    public Entity makeEntityFrom(String acceptHeader, String string) {
        return (Entity)((IXingYiResource)this.makesFromJson.fromJson(this.parserAndWriter, this.parserAndWriter.parse(string)));
    }

    @Override
    public boolean accept(String acceptHeader) {
        return acceptHeader.toLowerCase().startsWith(this.prefix);
    }

    @Override
    public DataToBeSentToClient makeDataAndDefn(ContextForJson context, Function<Entity, String> stateFn, Entity entity) {
        return this.makeDataAndDefnFor(context, ((HasJsonWithLinks)entity).toJsonWithLinks(this.parserAndWriter, context, stateFn));
    }

    @Override
    public DataToBeSentToClient makeDataAndDefn(ContextForJson context, Function<Entity, String> stateFn, IdAndValue<Entity> idAndValue) {
        return this.makeDataAndDefnFor(context, IdAndValue.toJson(idAndValue, this.parserAndWriter, context, stateFn));
    }

    abstract DataToBeSentToClient makeDataAndDefnFor(ContextForJson var1, J var2);
}

