/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.names;

import java.util.Optional;
import one.xingyi.core.codeDom.PackageAndClassName;
import one.xingyi.core.endpoints.BookmarkCodeAndUrlPattern;
import one.xingyi.core.names.EntityNames;
import one.xingyi.core.names.IClassNameStrategy;
import one.xingyi.core.names.IPackageNameStrategy;
import one.xingyi.core.names.IServerNames;
import one.xingyi.core.names.ViewNames;
import one.xingyi.core.utils.Optionals;
import one.xingyi.core.utils.Strings;
import one.xingyi.core.validation.Result;

class SimpleServerNames
implements IServerNames {
    final IPackageNameStrategy packageNameStrategy;
    final IClassNameStrategy classNameStrategy;

    @Override
    public EntityNames entityName(String className) {
        PackageAndClassName originalDefn = new PackageAndClassName(className);
        String originalPackage = originalDefn.packageName;
        String entityRoot = this.classNameStrategy.toRoot(originalDefn.className);
        PackageAndClassName serverInterface = new PackageAndClassName(this.packageNameStrategy.toServerImplForDomain(originalPackage), this.classNameStrategy.toServerInterfaceForDomain(entityRoot));
        PackageAndClassName serverEntity = new PackageAndClassName(this.packageNameStrategy.toServerImplForDomain(originalPackage), this.classNameStrategy.toServerImplForDomain(entityRoot));
        PackageAndClassName serverCompanion = new PackageAndClassName(this.packageNameStrategy.toServerCompanion(originalPackage), this.classNameStrategy.toClientViewCompanion(entityRoot));
        PackageAndClassName clientResourceCompanion = new PackageAndClassName(this.packageNameStrategy.toCompositeCompanion(originalPackage), this.classNameStrategy.toCompositeCompanion(entityRoot));
        PackageAndClassName clientEntity = new PackageAndClassName(this.packageNameStrategy.toClientEntityDefn(originalPackage), this.classNameStrategy.toClientEntityDefn(entityRoot));
        PackageAndClassName serverController = new PackageAndClassName(this.packageNameStrategy.toServerController(originalPackage), this.classNameStrategy.toServerController(entityRoot));
        return new EntityNames(originalDefn, serverInterface, serverEntity, serverCompanion, clientEntity, clientResourceCompanion, serverController, entityRoot);
    }

    @Override
    public ViewNames viewName(String className, String interfaceName) {
        PackageAndClassName originalDefn = new PackageAndClassName(className);
        String originalPackage = originalDefn.packageName;
        String viewRoot = this.classNameStrategy.toRoot(originalDefn.className);
        PackageAndClassName clientEntity = new PackageAndClassName(this.packageNameStrategy.toClientEntityDefn(originalPackage), this.classNameStrategy.toClientEntityDefn(viewRoot));
        PackageAndClassName clientViewInterface = new PackageAndClassName(this.packageNameStrategy.toClientViewInterface(originalPackage), this.classNameStrategy.toClientViewInterface(viewRoot));
        PackageAndClassName clientViewImpl = new PackageAndClassName(this.packageNameStrategy.toClientViewImpl(originalPackage), this.classNameStrategy.toClientViewImpl(viewRoot));
        PackageAndClassName clientCompanion = new PackageAndClassName(this.packageNameStrategy.toClientViewCompanion(originalPackage), this.classNameStrategy.toClientViewCompanion(viewRoot));
        EntityNames en = this.entityName(interfaceName);
        return new ViewNames(originalDefn, clientEntity, clientViewInterface, clientViewImpl, clientCompanion, en);
    }

    @Override
    public String entityLensName(EntityNames entityElementName, String fieldName, String annotationLensName) {
        return Strings.from(annotationLensName, "lens_" + entityElementName.entityNameForLens + "_" + fieldName);
    }

    @Override
    public Result<String, String> entityLensPath(EntityNames entityElementName, String fieldName, String annotationLensPath) {
        return Result.succeed(Strings.from(annotationLensPath, fieldName));
    }

    @Override
    public Optional<BookmarkCodeAndUrlPattern> bookmarkAndUrl(EntityNames entityElementName, String annotationBookmark, String annotationGetUrl, String codeUrl) {
        return Optionals.join(Strings.from(annotationBookmark), Strings.from(annotationGetUrl), (b, u) -> new BookmarkCodeAndUrlPattern((String)b, (String)u, Strings.from(codeUrl).orElse("{host}" + b + "/code")));
    }

    public SimpleServerNames(IPackageNameStrategy packageNameStrategy, IClassNameStrategy classNameStrategy) {
        this.packageNameStrategy = packageNameStrategy;
        this.classNameStrategy = classNameStrategy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleServerNames)) {
            return false;
        }
        SimpleServerNames other = (SimpleServerNames)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IPackageNameStrategy this$packageNameStrategy = this.packageNameStrategy;
        IPackageNameStrategy other$packageNameStrategy = other.packageNameStrategy;
        if (this$packageNameStrategy == null ? other$packageNameStrategy != null : !this$packageNameStrategy.equals(other$packageNameStrategy)) {
            return false;
        }
        IClassNameStrategy this$classNameStrategy = this.classNameStrategy;
        IClassNameStrategy other$classNameStrategy = other.classNameStrategy;
        return !(this$classNameStrategy == null ? other$classNameStrategy != null : !this$classNameStrategy.equals(other$classNameStrategy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleServerNames;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IPackageNameStrategy $packageNameStrategy = this.packageNameStrategy;
        result = result * 59 + ($packageNameStrategy == null ? 43 : $packageNameStrategy.hashCode());
        IClassNameStrategy $classNameStrategy = this.classNameStrategy;
        result = result * 59 + ($classNameStrategy == null ? 43 : $classNameStrategy.hashCode());
        return result;
    }

    public String toString() {
        return "SimpleServerNames(packageNameStrategy=" + this.packageNameStrategy + ", classNameStrategy=" + this.classNameStrategy + ")";
    }
}

